/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCEmptyObjectIterator_V1;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCMixedObjectIterator_V1;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm23.j9.gc.GCPointerArrayIterator_V1;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.structure.J9Object;

public abstract class GCObjectIterator
extends GCIterator {
    protected J9ObjectPointer object;
    protected boolean includeClassSlot;

    protected GCObjectIterator(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        this.object = object;
        this.includeClassSlot = includeClassSlot;
    }

    public static GCObjectIterator fromJ9Object(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        GCObjectModel objectModel = GCObjectModel.fromJ9JavaVM(vm);
        if (objectModel.isIndexable(object)) {
            if (objectModel.getObjectShape(object).longValue() == J9Object.OBJECT_HEADER_SHAPE_POINTERS) {
                return GCObjectIterator.getPointerArrayImpl(vm, object, includeClassSlot);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(vm, object, includeClassSlot);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(vm, object, includeClassSlot);
    }

    public abstract J9ObjectPointer next();

    private static GCObjectIterator getPointerArrayImpl(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAY_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCPointerArrayIterator_V1(vm, object, includeClassSlot);
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(vm, object, includeClassSlot);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(vm, object, includeClassSlot);
    }
}

