/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.ObjectModel;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCPointerArrayIterator_V1
extends GCObjectIterator {
    protected UDATAPointer data;
    protected int scanIndex = 0;
    protected int scanLimit;

    protected GCPointerArrayIterator_V1(J9JavaVMPointer vm, J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        super(vm, object, includeClassSlot);
        this.scanLimit = ObjectModel.getSizeInElements(object).intValue();
        this.data = UDATAPointer.cast(J9IndexableObjectPointer.cast(object).add(1L));
    }

    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return J9ObjectPointer.cast(this.object.clazz());
                }
                J9ObjectPointer next = J9ObjectPointer.cast(this.data.at(this.scanIndex));
                ++this.scanIndex;
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }

    public boolean hasNext() {
        if (this.includeClassSlot) {
            return true;
        }
        return this.scanIndex < this.scanLimit;
    }
}

