/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCDebuggerClassReferenceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCDebuggerReferenceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCFinalizableListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCFinalizableListSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCJVMTIObjectTagTableIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCJVMTIObjectTagTableListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCPhantomReferenceObjectListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCReferenceObjectListSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCSoftReferenceObjectListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCUnfinalizedListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCUnfinalizedListSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadJNISlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadMonitorRecordSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadSlotIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCWeakReferenceObjectListIterator;
import com.ibm.j9ddr.vm23.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9DebuggerReferencePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JVMTIDataPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.pointer.generated.MM_EnvironmentModronPointer;
import com.ibm.j9ddr.vm23.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm23.structure.J9MemorySegment;
import com.ibm.j9ddr.vm23.structure.MM_GCExtensionsCore;

public abstract class RootScanner {
    protected MM_EnvironmentModronPointer _env;
    protected MM_GCExtensionsPointer _extensions;
    protected J9JavaVMPointer _javaVM;
    private Reachability _reachability = Reachability.STRONG;

    protected RootScanner(MM_EnvironmentModronPointer env) throws CorruptDataException {
        this._env = env;
        this._javaVM = env._javaVM();
        this._extensions = MM_GCExtensionsPointer.cast(this._javaVM.gcExtensions());
    }

    protected abstract void doClassSlot(J9ClassPointer var1);

    protected abstract void doClassLoader(J9ClassLoaderPointer var1);

    protected abstract void doWeakReferenceSlot(J9ObjectPointer var1);

    protected abstract void doSoftReferenceSlot(J9ObjectPointer var1);

    protected abstract void doPhantomReferenceSlot(J9ObjectPointer var1);

    protected abstract void doFinalizableSlot(GC_FinalizerJobPointer var1);

    protected abstract void doUnfinalizedSlot(J9ObjectPointer var1);

    protected abstract void doDebuggerReference(J9DebuggerReferencePointer var1);

    protected abstract void doDebuggerClassReference(J9DebuggerReferencePointer var1);

    protected abstract void doMonitorReference(J9ThreadAbstractMonitorPointer var1);

    protected abstract void doJNIWeakGlobalReference(J9ObjectPointer var1);

    protected abstract void doJNIGlobalReferenceSlot(J9ObjectPointer var1);

    protected abstract void doRememberedSlot(J9ObjectPointer var1);

    protected abstract void doJVMTIObjectTagSlot(J9ObjectPointer var1);

    protected abstract void doStringTableSlot(J9ObjectPointer var1);

    protected abstract void doVMClassSlot(J9ClassPointer var1);

    protected abstract void doVMThreadSlot(J9ObjectPointer var1);

    protected abstract void doVMThreadJNISlot(J9ObjectPointer var1);

    protected abstract void doVMThreadMonitorRecordSlot(J9ObjectPointer var1);

    public void scanAllSlots() throws CorruptDataException {
        this.scanClasses();
        this.scanVMClassSlots();
        if (!J9BuildFlags.opt_cldcOnly) {
            this.scanClassLoaders();
        }
        this.scanThreads();
        if (J9BuildFlags.gc_finalization) {
            this.scanFinalizableObjects();
        }
        if (J9BuildFlags.interp_jniSupport || J9BuildFlags.interp_debugSupport) {
            this.scanJNIGlobalReferences();
        }
        this.scanStringTable();
        if (J9BuildFlags.gc_weakReferenceObjects) {
            this.scanWeakReferenceObjects();
        }
        if (J9BuildFlags.gc_referenceObjects) {
            this.scanSoftReferenceObjects();
            this.scanPhantomReferenceObjects();
        }
        if (J9BuildFlags.gc_finalization) {
            this.scanUnfinalizedObjects();
        }
        this.scanMonitorReferences();
        if (J9BuildFlags.interp_jniSupport) {
            this.scanJNIWeakGlobalReferences();
        }
        if (J9BuildFlags.interp_debugSupport) {
            this.scanDebuggerReferences();
            this.scanDebuggerClassReferences();
        }
        if (J9BuildFlags.gc_modronScavenger && !this._extensions.scavengerEnabled().eq(0L)) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.opt_jvmti) {
            this.scanJVMTIObjectTagTables();
        }
    }

    protected void scanJVMTIObjectTagTables() throws CorruptDataException {
        if (!J9BuildFlags.opt_jvmti) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        J9JVMTIDataPointer jvmtiData = J9JVMTIDataPointer.cast(this._javaVM.jvmtiData());
        if (jvmtiData.notNull()) {
            GCJVMTIObjectTagTableListIterator objectTagTableList = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(jvmtiData);
            while (objectTagTableList.hasNext()) {
                GCJVMTIObjectTagTableIterator objectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(objectTagTableList.next());
                while (objectTagTableIterator.hasNext()) {
                    this.doJVMTIObjectTagSlot(objectTagTableIterator.next());
                }
            }
        }
    }

    protected void scanRememberedSet() throws CorruptDataException {
        if (!J9BuildFlags.gc_modronScavenger) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCRememberedSetIterator rememberedSetIterator = GCRememberedSetIterator.fromGCExtensions(this._extensions);
        while (rememberedSetIterator.hasNext()) {
            GCRememberedSetSlotIterator rememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(rememberedSetIterator.next());
            while (rememberedSetSlotIterator.hasNext()) {
                this.doRememberedSlot(rememberedSetSlotIterator.next());
            }
        }
    }

    protected void scanDebuggerClassReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCDebuggerClassReferenceIterator debuggerClassReferenceIterator = GCDebuggerClassReferenceIterator.fromJ9JavaVM(this._javaVM);
        while (debuggerClassReferenceIterator.hasNext()) {
            this.doDebuggerClassReference(debuggerClassReferenceIterator.next());
        }
    }

    protected void scanDebuggerReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCDebuggerReferenceIterator debuggerReferenceIterator = GCDebuggerReferenceIterator.fromJ9JavaVM(this._javaVM);
        while (debuggerReferenceIterator.hasNext()) {
            this.doDebuggerReference(debuggerReferenceIterator.next());
        }
    }

    protected void scanJNIWeakGlobalReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_jniSupport && !J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCJNIWeakGlobalReferenceIterator jniWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.fromJ9JavaVM(this._javaVM);
        while (jniWeakGlobalReferenceIterator.hasNext()) {
            this.doJNIWeakGlobalReference(jniWeakGlobalReferenceIterator.next());
        }
    }

    protected void scanMonitorReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.fromJ9JavaVM(this._javaVM);
        while (monitorReferenceIterator.hasNext()) {
            this.doMonitorReference(monitorReferenceIterator.next());
        }
    }

    protected void scanUnfinalizedObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCUnfinalizedListIterator unfinalizedListIterator = GCUnfinalizedListIterator.fromGCExtensions(this._extensions);
        while (unfinalizedListIterator.hasNext()) {
            GCUnfinalizedListSlotIterator unfinalizedListSlotIterator = GCUnfinalizedListSlotIterator.fromSublistPuddle(unfinalizedListIterator.next());
            while (unfinalizedListSlotIterator.hasNext()) {
                this.doUnfinalizedSlot(unfinalizedListSlotIterator.next());
            }
        }
    }

    protected void scanPhantomReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_referenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCPhantomReferenceObjectListIterator referenceObjectListIterator = GCPhantomReferenceObjectListIterator.fromGCExtensions(this._extensions);
        while (referenceObjectListIterator.hasNext()) {
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(referenceObjectListIterator.next());
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doPhantomReferenceSlot(referenceObjectListSlotIterator.next());
            }
        }
    }

    protected void scanSoftReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_referenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCSoftReferenceObjectListIterator referenceObjectListIterator = GCSoftReferenceObjectListIterator.fromGCExtensions(this._extensions);
        while (referenceObjectListIterator.hasNext()) {
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(referenceObjectListIterator.next());
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doSoftReferenceSlot(referenceObjectListSlotIterator.next());
            }
        }
    }

    protected void scanWeakReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_weakReferenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCWeakReferenceObjectListIterator referenceObjectListIterator = GCWeakReferenceObjectListIterator.fromGCExtensions(this._extensions);
        while (referenceObjectListIterator.hasNext()) {
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(referenceObjectListIterator.next());
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doWeakReferenceSlot(referenceObjectListSlotIterator.next());
            }
        }
    }

    protected void scanStringTable() throws CorruptDataException {
        if (this._extensions.collectStringConstants()) {
            this.setReachability(Reachability.WEAK);
        } else {
            this.setReachability(Reachability.STRONG);
        }
        GCStringTableIterator stringTableIterator = GCStringTableIterator.fromJ9JavaVM(this._javaVM);
        while (stringTableIterator.hasNext()) {
            this.doStringTableSlot(stringTableIterator.next());
        }
    }

    protected void scanJNIGlobalReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_jniSupport && !J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.STRONG);
        GCJNIGlobalReferenceIterator jniGlobalReferenceIterator = GCJNIGlobalReferenceIterator.fromJ9JavaVM(this._javaVM);
        while (jniGlobalReferenceIterator.hasNext()) {
            this.doJNIGlobalReferenceSlot(jniGlobalReferenceIterator.next());
        }
    }

    protected void scanFinalizableObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.STRONG);
        GCFinalizableListIterator finalizableListIterator = GCFinalizableListIterator.fromFinalizeListManager(this._extensions.finalizeListManager());
        while (finalizableListIterator.hasNext()) {
            GCFinalizableListSlotIterator finalizableListSlotIterator = GCFinalizableListSlotIterator.fromFinalizeList(finalizableListIterator.next());
            while (finalizableListSlotIterator.hasNext()) {
                this.doFinalizableSlot(finalizableListSlotIterator.next());
            }
        }
    }

    protected void scanThreads() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.fromJ9JavaVM(this._javaVM);
        while (vmThreadListIterator.hasNext()) {
            J9VMThreadPointer walkThread = vmThreadListIterator.next();
            GCVMThreadSlotIterator threadSlotIterator = GCVMThreadSlotIterator.fromJ9VMThread(walkThread);
            while (threadSlotIterator.hasNext()) {
                this.doVMThreadSlot(threadSlotIterator.next());
            }
            if (J9BuildFlags.interp_jniSupport) {
                GCVMThreadJNISlotIterator jniSlotIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(walkThread);
                while (jniSlotIterator.hasNext()) {
                    this.doVMThreadJNISlot(jniSlotIterator.next());
                }
            }
            if (!J9BuildFlags.interp_hotCodeReplacement) continue;
            GCVMThreadMonitorRecordSlotIterator monitorRecordSlotIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(walkThread);
            while (monitorRecordSlotIterator.hasNext()) {
                this.doVMThreadMonitorRecordSlot(monitorRecordSlotIterator.next());
            }
        }
    }

    protected void scanClassLoaders() throws CorruptDataException {
        if (J9BuildFlags.opt_cldcOnly) {
            return;
        }
        J9ClassLoaderPointer sysClassLoader = this._javaVM.systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(this._javaVM.applicationClassLoader());
        long dynamicClassUnloadingFlag = this._extensions.dynamicClassUnloading();
        GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.fromJ9JavaVM(this._javaVM);
        while (classLoaderIterator.hasNext()) {
            J9ClassLoaderPointer loader = classLoaderIterator.next();
            Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsCore.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == dynamicClassUnloadingFlag ? Reachability.STRONG : (loader.eq(sysClassLoader) || loader.eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
            this.setReachability(reachability);
            this.doClassLoader(loader);
        }
    }

    protected void scanVMClassSlots() throws CorruptDataException {
        GCVMClassSlotIterator classSlotIterator = GCVMClassSlotIterator.fromJ9JavaVM(this._javaVM);
        this.setReachability(Reachability.STRONG);
        while (classSlotIterator.hasNext()) {
            this.doVMClassSlot(classSlotIterator.next());
        }
    }

    protected void scanClasses() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = this._javaVM.systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(this._javaVM.applicationClassLoader());
        long dynamicClassUnloadingFlag = this._extensions.dynamicClassUnloading();
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._javaVM.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            if (!this.shouldScanClassSegment(segment)) continue;
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(this._javaVM, segment);
            while (classHeapIterator.hasNext()) {
                J9ClassPointer clazz = classHeapIterator.next();
                Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsCore.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == dynamicClassUnloadingFlag ? Reachability.STRONG : (clazz.classLoader().eq(sysClassLoader) || clazz.classLoader().eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
                this.setReachability(reachability);
                this.doClassSlot(clazz);
            }
        }
    }

    private void setReachability(Reachability r) {
        this._reachability = r;
    }

    protected Reachability getReachability() {
        return this._reachability;
    }

    protected boolean shouldScanClassSegment(J9MemorySegmentPointer segment) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reachability {
        STRONG,
        WEAK;

    }
}

