/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.types.I32;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;

public abstract class StructurePointer
extends AbstractPointer {
    private static final String nl = System.getProperty("line.separator");

    protected StructurePointer(long address) {
        super(address);
    }

    public DataType at(long count) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(long count) instead.");
    }

    public DataType at(Scalar count) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(Scalar count) instead.");
    }

    protected int getStartingBit(int s, int b) {
        switch (BITFIELD_FORMAT) {
            case 1: {
                return b + s % 32;
            }
            case 2: {
                return 32 - s % 32;
            }
        }
        throw new IllegalArgumentException("Unsupported bitfield format");
    }

    protected U32 getU32Bitfield(int s, int b) throws CorruptDataException {
        int cell = s / 32;
        U32 cellValue = new U32(this.getIntAtOffset(cell * 32 / 8));
        int n = this.getStartingBit(s, b);
        U32 returnValue = cellValue.leftShift(32 - n);
        returnValue = returnValue.rightShift(32 - b);
        return returnValue;
    }

    protected I32 getI32Bitfield(int s, int b) throws CorruptDataException {
        int cell = s / 32;
        I32 cellValue = new I32(this.getIntAtOffset(cell * 32 / 8));
        int n = this.getStartingBit(s, b);
        I32 returnValue = cellValue.leftShift(32 - n);
        returnValue = returnValue.rightShift(32 - b);
        return returnValue;
    }

    public String formatFullInteractive() {
        GeneratedPointerClass classAnnotation;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTargetName());
        builder.append(" at ");
        builder.append("0x");
        builder.append(Long.toHexString(this.getAddress()));
        builder.append(" {");
        builder.append(nl);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StructureField
        implements Comparable<StructureField> {
            final int offset;
            final String name;
            final DataType value;
            final String type;
            final CorruptDataException cde;

            StructureField(String name, String type, int offset, DataType value, CorruptDataException cde) {
                this.name = name;
                this.offset = offset;
                this.value = value;
                this.type = type;
                this.cde = cde;
            }

            @Override
            public int compareTo(StructureField o) {
                return this.offset - o.offset;
            }
        }
        LinkedList<StructureField> fields = new LinkedList<StructureField>();
        for (Class<?> working = this.getClass(); working != null && null != (classAnnotation = working.getAnnotation(GeneratedPointerClass.class)); working = working.getSuperclass()) {
            for (Method thisMethod : working.getMethods()) {
                if (!thisMethod.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                GeneratedFieldAccessor fieldAnnotation = thisMethod.getAnnotation(GeneratedFieldAccessor.class);
                Field offsetField = null;
                try {
                    offsetField = classAnnotation.structureClass().getField(fieldAnnotation.offsetFieldName());
                }
                catch (SecurityException e) {
                    throw new Error("Unexpected security exception", e);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                int offset = -1;
                try {
                    offset = offsetField.getInt(null);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
                DataType result = null;
                CorruptDataException cde = null;
                try {
                    result = (DataType)thisMethod.invoke((Object)this, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CorruptDataException) {
                        cde = (CorruptDataException)cause;
                    }
                    throw new RuntimeException(e);
                }
                fields.add(new StructureField(thisMethod.getName(), fieldAnnotation.declaredType(), offset, result, cde));
            }
        }
        Collections.sort(fields);
        for (StructureField thisField : fields) {
            builder.append("\t0x");
            builder.append(Integer.toHexString(thisField.offset));
            builder.append(": ");
            builder.append(thisField.type);
            builder.append(" ");
            builder.append(thisField.name);
            builder.append(" = ");
            if (thisField.cde != null) {
                builder.append("<FAULT: " + thisField.cde.getMessage() + ">");
            } else if (thisField.value != null) {
                builder.append(thisField.value.formatShortInteractive());
            } else {
                builder.append("null");
            }
            builder.append(nl);
        }
        builder.append("}");
        builder.append("\n");
        return builder.toString();
    }
}

