/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.UDATA;

public class U16Pointer
extends Pointer {
    public static final int SIZEOF = 2;
    public static final U16Pointer NULL = new U16Pointer(0L);

    protected U16Pointer(long address) {
        super(address);
    }

    public static U16Pointer cast(AbstractPointer pointer) {
        return U16Pointer.cast(pointer.getAddress());
    }

    public static U16Pointer cast(UDATA udata) {
        return U16Pointer.cast(udata.longValue());
    }

    public static U16Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new U16Pointer(address);
    }

    public U16 at(long index) throws CorruptDataException {
        return new U16(this.getShortAtOffset(index * 2L));
    }

    public U16 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public U16Pointer untag() {
        return this.untag(1L);
    }

    public U16Pointer untag(long mask) {
        return new U16Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public U16Pointer add(long count) {
        return new U16Pointer(this.address + 2L * count);
    }

    public U16Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public U16Pointer addOffset(long offset) {
        return new U16Pointer(this.address + offset);
    }

    public U16Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public U16Pointer sub(long count) {
        return new U16Pointer(this.address - 2L * count);
    }

    public U16Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public U16Pointer subOffset(long offset) {
        return new U16Pointer(this.address - offset);
    }

    public U16Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return 2L;
    }
}

