/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9RAMConstantPoolItemPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm23.structure.J9ConstantPool;
import com.ibm.j9ddr.vm23.structure.J9RAMConstantPoolItem;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9ConstantPool.class)
public class J9ConstantPoolPointer
extends StructurePointer {
    public static final J9ConstantPoolPointer NULL = new J9ConstantPoolPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    public J9RAMConstantPoolItemPointer ramEntryAt(long index) throws CorruptDataException {
        if (index < 0L || index > this.ramClass().romClass().ramConstantPoolCount().longValue()) {
            throw new IndexOutOfBoundsException();
        }
        return J9RAMConstantPoolItemPointer.cast(this.addOffset(J9RAMConstantPoolItem.SIZEOF * index));
    }

    protected J9ConstantPoolPointer(long address) {
        super(address);
    }

    public static J9ConstantPoolPointer cast(AbstractPointer structure) {
        return J9ConstantPoolPointer.cast(structure.getAddress());
    }

    public static J9ConstantPoolPointer cast(UDATA udata) {
        return J9ConstantPoolPointer.cast(udata.longValue());
    }

    public static J9ConstantPoolPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ConstantPoolPointer(address);
    }

    public J9ConstantPoolPointer add(long count) {
        return J9ConstantPoolPointer.cast(this.address + J9ConstantPool.SIZEOF * count);
    }

    public J9ConstantPoolPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9ConstantPoolPointer addOffset(long offset) {
        return J9ConstantPoolPointer.cast(this.address + offset);
    }

    public J9ConstantPoolPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9ConstantPoolPointer sub(long count) {
        return J9ConstantPoolPointer.cast(this.address - J9ConstantPool.SIZEOF * count);
    }

    public J9ConstantPoolPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9ConstantPoolPointer subOffset(long offset) {
        return J9ConstantPoolPointer.cast(this.address - offset);
    }

    public J9ConstantPoolPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9ConstantPoolPointer untag(long mask) {
        return J9ConstantPoolPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9ConstantPoolPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9ConstantPool.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_ramClassOffset_", declaredType="struct J9Class*")
    public J9ClassPointer ramClass() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9ConstantPool._ramClassOffset_);
        return J9ClassPointer.cast(pointer);
    }

    public PointerPointer ramClassEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ConstantPool._ramClassOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romConstantPoolOffset_", declaredType="struct J9ROMConstantPoolItem*")
    public J9ROMConstantPoolItemPointer romConstantPool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9ConstantPool._romConstantPoolOffset_);
        return J9ROMConstantPoolItemPointer.cast(pointer);
    }

    public PointerPointer romConstantPoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ConstantPool._romConstantPoolOffset_);
    }
}

