/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.I32Pointer;
import com.ibm.j9ddr.vm23.pointer.I64Pointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm23.structure.J9Object;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

@GeneratedPointerClass(structureClass=J9Object.class)
public class J9ObjectPointer
extends StructurePointer {
    public static final J9ObjectPointer NULL = new J9ObjectPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    public String getClassName() throws CorruptDataException {
        return this.clazz().getName();
    }

    public String stringValue() throws CorruptDataException {
        if (!this.getClassName().equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        J9ObjectPointer charsObject = this.getObjectField(this.getFieldOffset("value", "[C"));
        J9IndexableObjectPointer charsArray = J9IndexableObjectPointer.cast(charsObject);
        char[] value = (char[])charsArray.getData();
        int offset = this.getIntField(this.getFieldOffset("offset", "I"));
        int count = this.getIntField(this.getFieldOffset("count", "I"));
        return new String(value, offset, count);
    }

    public String getStringField(J9ObjectFieldOffset offset) throws CorruptDataException {
        J9ObjectPointer stringObject = this.getObjectField(offset);
        if (stringObject.isNull()) {
            return null;
        }
        return stringObject.stringValue();
    }

    public int getIntField(J9ObjectFieldOffset offset) throws CorruptDataException {
        I32Pointer pointer = offset.isStatic() ? I32Pointer.cast(this.clazz().ramStatics().addOffset(offset.getOffsetOrAddress())) : I32Pointer.cast(this.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).intValue();
    }

    public short getShortField(J9ObjectFieldOffset offset) throws CorruptDataException {
        return (short)(this.getIntField(offset) & 0xFFFF);
    }

    public float getFloatField(J9ObjectFieldOffset offset) throws CorruptDataException {
        int data = this.getIntField(offset);
        return Float.intBitsToFloat(data);
    }

    public double getDoubleField(J9ObjectFieldOffset offset) throws CorruptDataException {
        long data = this.getLongField(offset);
        return Double.longBitsToDouble(data);
    }

    public char getCharField(J9ObjectFieldOffset offset) throws CorruptDataException {
        return (char)(this.getIntField(offset) & 0xFFFF);
    }

    public byte getByteField(J9ObjectFieldOffset offset) throws CorruptDataException {
        return (byte)(this.getIntField(offset) & 0xFF);
    }

    public boolean getBooleanField(J9ObjectFieldOffset offset) throws CorruptDataException {
        return this.getIntField(offset) != 0;
    }

    public long getLongField(J9ObjectFieldOffset offset) throws CorruptDataException {
        I64Pointer pointer = offset.isStatic() ? I64Pointer.cast(this.clazz().ramStatics().addOffset(offset.getOffsetOrAddress())) : I64Pointer.cast(this.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).longValue();
    }

    public J9ObjectPointer getObjectField(J9ObjectFieldOffset offset) throws CorruptDataException {
        if (offset.isStatic()) {
            UDATAPointer pointer = this.clazz().ramStatics().addOffset(offset.getOffsetOrAddress());
            return J9ObjectPointer.cast(pointer.at(0L));
        }
        return J9ObjectPointer.cast(this.getPointerAtOffset(J9Object.SIZEOF + offset.getOffsetOrAddress().longValue()));
    }

    private J9ObjectFieldOffset getFieldOffset(String name, String signature) throws CorruptDataException {
        J9ObjectFieldOffset result = this.clazz().checkFieldOffsetCache(name, signature);
        if (result == null) {
            result = this.readFieldOffset(name, signature);
            this.clazz().setFieldOffsetCache(result, name, signature);
        }
        return result;
    }

    private J9ObjectFieldOffset readFieldOffset(String name, String signature) throws CorruptDataException {
        J9ClassPointer currentClass = this.clazz();
        while (currentClass != null) {
            Iterator fields = currentClass.getFieldOffsets(J9ClassPointer.SUPERCLASS(currentClass));
            while (fields.hasNext()) {
                J9ObjectFieldOffset field = (J9ObjectFieldOffset)fields.next();
                if (!field.getName().equals(name) || !field.getSignature().equals(signature)) continue;
                return field;
            }
            currentClass = J9ClassPointer.SUPERCLASS(currentClass);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", name, signature, this.getClassName()));
    }

    protected J9ObjectPointer(long address) {
        super(address);
    }

    public static J9ObjectPointer cast(AbstractPointer structure) {
        return J9ObjectPointer.cast(structure.getAddress());
    }

    public static J9ObjectPointer cast(UDATA udata) {
        return J9ObjectPointer.cast(udata.longValue());
    }

    public static J9ObjectPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ObjectPointer(address);
    }

    public J9ObjectPointer add(long count) {
        return J9ObjectPointer.cast(this.address + J9Object.SIZEOF * count);
    }

    public J9ObjectPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9ObjectPointer addOffset(long offset) {
        return J9ObjectPointer.cast(this.address + offset);
    }

    public J9ObjectPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9ObjectPointer sub(long count) {
        return J9ObjectPointer.cast(this.address - J9Object.SIZEOF * count);
    }

    public J9ObjectPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9ObjectPointer subOffset(long offset) {
        return J9ObjectPointer.cast(this.address - offset);
    }

    public J9ObjectPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9ObjectPointer untag(long mask) {
        return J9ObjectPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9ObjectPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9Object.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_clazzOffset_", declaredType="struct J9Class*")
    public J9ClassPointer clazz() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9Object._clazzOffset_);
        return J9ClassPointer.cast(pointer);
    }

    public PointerPointer clazzEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Object._clazzOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
    public U32 flags() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Object._flagsOffset_));
    }

    public U32Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9Object._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_monitorOffset_", declaredType="UDATA")
    public UDATA monitor() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Object._monitorOffset_));
    }

    public UDATAPointer monitorEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Object._monitorOffset_);
    }
}

