/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.IDTFJJavaField;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import java.util.HashMap;
import java.util.Map;

public abstract class DTFJJavaField
implements JavaField,
IDTFJJavaField {
    protected static final Class<?>[] whitelist = new Class[]{IllegalArgumentException.class};
    protected static final int FIELD_BOOLEAN = 1;
    protected static final int FIELD_BYTE = 2;
    protected static final int FIELD_SHORT = 4;
    protected static final int FIELD_CHAR = 8;
    protected static final int FIELD_INTEGER = 16;
    protected static final int FIELD_FLOAT = 32;
    protected static final int FIELD_LONG = 64;
    protected static final int FIELD_DOUBLE = 128;
    protected static final int FIELD_ARRAY = 256;
    protected static final int FIELD_OBJECT = 512;
    protected final J9ROMFieldShapePointer j9field;
    protected final J9ObjectFieldOffset fieldOffset;
    protected final String name;
    protected DTFJJavaClass clazz = null;
    protected int modifiers = 0;
    private char sigFlag = '\u0000';
    private static Map<J9ROMFieldShapePointer, String> signatureCache = new HashMap<J9ROMFieldShapePointer, String>();

    public DTFJJavaField(DTFJJavaClass clazz, J9ObjectFieldOffset ptr) throws CorruptDataException {
        this.clazz = clazz;
        this.fieldOffset = ptr;
        this.j9field = ptr.getField();
        this.modifiers = this.j9field.modifiers().intValue();
        this.name = this.j9field.getName();
    }

    protected char getSigFlag() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.sigFlag == '\u0000') {
            this.sigFlag = this.getSignature().charAt(0);
        }
        switch (this.sigFlag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return this.sigFlag;
            }
        }
        throw J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), new CorruptDataException("Signature flag for this field is invalid: " + this.sigFlag + String.format("[\\u%04x]", this.sigFlag)));
    }

    protected DTFJJavaObject validateJavaObject(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException {
        if (!(object instanceof DTFJJavaObject)) {
            throw new IllegalArgumentException(String.format("Unregonised JavaObject implementor : %s", object.getClass().getName()));
        }
        if (!this.isAncestorOf(object.getJavaClass())) {
            throw new IllegalArgumentException("The class for the JavaObject specified as a parameter does not match with the declaring class of this JavaField.");
        }
        return (DTFJJavaObject)object;
    }

    protected long checkDataTypeConversion(DTFJJavaObject object, int mask) throws com.ibm.dtfj.image.CorruptDataException {
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    if ((mask & 1) != 1) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
                case 'B': {
                    if ((mask & 2) != 2) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getByteField(this.fieldOffset);
                }
                case 'C': {
                    if ((mask & 8) != 8) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getCharField(this.fieldOffset);
                }
                case 'S': {
                    if ((mask & 4) != 4) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getShortField(this.fieldOffset);
                }
                case 'I': {
                    if ((mask & 0x10) != 16) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getIntField(this.fieldOffset);
                }
                case 'F': {
                    if ((mask & 0x20) != 32) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getIntField(this.fieldOffset);
                }
                case 'J': {
                    if ((mask & 0x40) != 64) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getLongField(this.fieldOffset);
                }
                case 'D': {
                    if ((mask & 0x80) != 128) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return object.getJ9ObjectPointer().getLongField(this.fieldOffset);
                }
                case '[': {
                    if ((mask & 0x100) != 256) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
                case 'L': {
                    if ((mask & 0x200) != 512) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data size");
        }
        catch (CorruptDataException e) {
            throw J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), e);
        }
    }

    protected boolean isAncestorOf(JavaClass theClass) {
        if (null == theClass) {
            return false;
        }
        if (this.clazz.equals(theClass)) {
            return true;
        }
        try {
            return this.isAncestorOf(theClass.getSuperclass());
        }
        catch (com.ibm.dtfj.image.CorruptDataException cde) {
            return false;
        }
    }

    public JavaClass getDeclaringClass() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        if (this.clazz == null) {
            throw new DataUnavailable("The declaring class is not available");
        }
        return this.clazz;
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        return this.modifiers;
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        return this.name;
    }

    public String getSignature() throws com.ibm.dtfj.image.CorruptDataException {
        String cachedSignature = signatureCache.get(this.j9field);
        if (null == cachedSignature) {
            try {
                cachedSignature = this.j9field.getSignature();
                signatureCache.put(this.j9field, cachedSignature);
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return cachedSignature;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaField) {
            boolean hasSameName;
            JavaField field = (JavaField)obj;
            try {
                hasSameName = this.name.equals(field.getName());
            }
            catch (com.ibm.dtfj.image.CorruptDataException cde) {
                hasSameName = false;
            }
            try {
                isEqual = hasSameName && this.getClass().equals(field.getClass()) && this.clazz.equals(field.getDeclaringClass());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        try {
            data.append(this.getName());
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            data.append("Instance Field [unknown name]");
        }
        data.append(" @0x");
        data.append(Long.toHexString(this.j9field.getAddress()));
        return data.toString();
    }
}

