/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.j9.walkers.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm24.j9.walkers.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm24.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm24.structure.J9FieldFlags;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.NoSuchElementException;

public class J9ObjectFieldOffsetIterator_V1
extends J9ObjectFieldOffsetIterator {
    private J9ROMClassPointer romClass;
    private J9ClassPointer superClazz;
    private J9ROMFieldShapeIterator romFieldsShapeIterator;
    private J9ClassPointer clazz;
    private U32 doubleCount = new U32(0L);
    private U32 doubleSeen = new U32(0L);
    private U32 doubleStaticsSeen = new U32(0L);
    private U32 objectCount = new U32(0L);
    private U32 objectsSeen = new U32(0L);
    private U32 objectStaticsSeen = new U32(0L);
    private U32 singleCount = new U32(0L);
    private U32 singlesSeen = new U32(0L);
    private U32 singleStaticsSeen = new U32(0L);
    private U32 walkFlags = new U32(0L);
    private UDATA firstDoubleOffset = new UDATA(0L);
    private UDATA firstObjectOffset = new UDATA(0L);
    private UDATA firstSingleOffset = new UDATA(0L);
    private IDATA backfillOffset = new IDATA(-1L);
    private IDATA backfillOffsetToUse = new IDATA(-1L);
    private U32 backfillEligibleFields = new U32(0L);
    private J9ROMFieldShapePointer field;
    private UDATA instanceSize = new UDATA(0L);
    private UDATA offset = new UDATA(0L);
    private UDATA superTotalInstanceSize = new UDATA(0L);

    protected J9ObjectFieldOffsetIterator_V1(J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        this.clazz = clazz;
        this.superClazz = superClazz;
        this.walkFlags = flags;
    }

    private void init() throws CorruptDataException {
        this.romClass = this.clazz.romClass();
        this.initInstanceSize(this.romClass, this.superClazz);
        this.romFieldsShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
    }

    private void nextImpl() throws CorruptDataException {
        while (this.romFieldsShapeIterator.hasNext()) {
            this.field = (J9ROMFieldShapePointer)this.romFieldsShapeIterator.next();
            U32 modifiers = this.field.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) {
                if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    this.offset = new UDATA(this.objectStaticsSeen.mult(UDATA.SIZEOF));
                    this.objectStaticsSeen = this.objectStaticsSeen.add(1);
                    break;
                }
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    UDATA doubleSlots = J9BuildFlags.env_data64 ? new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount())) : new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount()).add(1)).rightShift(1);
                    this.offset = doubleSlots.mult(8).add(this.doubleStaticsSeen.mult(8));
                    this.doubleStaticsSeen = this.doubleStaticsSeen.add(1);
                    break;
                }
                this.offset = new UDATA(this.romClass.objectStaticCount().mult(UDATA.SIZEOF).add(this.singleStaticsSeen.mult(UDATA.SIZEOF)));
                this.singleStaticsSeen = this.singleStaticsSeen.add(1);
                break;
            }
            if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD)) {
                    this.offset = new UDATA(this.backfillOffsetToUse);
                    this.walkFlags = this.walkFlags.bitAnd(new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD).bitNot());
                    break;
                }
                this.offset = this.firstObjectOffset.add(this.objectsSeen.mult((int)ObjectReferencePointer.SIZEOF));
                this.objectsSeen = this.objectsSeen.add(1);
                break;
            }
            if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.offset = this.firstDoubleOffset.add(this.doubleSeen.mult(8));
                this.doubleSeen = this.doubleSeen.add(1);
                break;
            }
            if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                this.offset = new UDATA(this.backfillOffsetToUse);
                this.walkFlags = this.walkFlags.bitAnd(new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD).bitNot());
                break;
            }
            this.offset = this.firstSingleOffset.add(this.singlesSeen.mult(4));
            this.singlesSeen = this.singlesSeen.add(1);
            break;
        }
    }

    private void initInstanceSize(J9ROMClassPointer romClass, J9ClassPointer superClazz) throws CorruptDataException {
        boolean volatileLongFound = false;
        this.backfillEligibleFields = new U32(0L);
        if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE)) {
            return;
        }
        if (J9BuildFlags.opt_alignLongVolatileFieldOffsets) {
            volatileLongFound = false;
        }
        this.superTotalInstanceSize = superClazz.isNull() ? new UDATA(0L) : superClazz.totalInstanceSize();
        this.backfillOffset = superClazz.isNull() ? new IDATA(-1L) : superClazz.backfillOffset();
        this.backfillOffsetToUse = new IDATA(-1L);
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(romClass.romFields(), romClass.romFieldCount());
        while (fields.hasNext()) {
            J9ROMFieldShapePointer field = (J9ROMFieldShapePointer)fields.next();
            U32 modifiers = field.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                this.objectCount = this.objectCount.add(1);
                this.backfillEligibleFields = this.backfillEligibleFields.add(ObjectReferencePointer.SIZEOF == 4L ? 1 : 0);
                continue;
            }
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.doubleCount = this.doubleCount.add(1);
                if (!J9BuildFlags.opt_alignLongVolatileFieldOffsets || !modifiers.anyBitsIn(J9JavaAccessFlags.J9AccVolatile)) continue;
                volatileLongFound = true;
                continue;
            }
            this.singleCount = this.singleCount.add(1);
            this.backfillEligibleFields = this.backfillEligibleFields.add(1);
        }
        this.firstDoubleOffset = this.superTotalInstanceSize;
        if (J9BuildFlags.opt_alignLongVolatileFieldOffsets && volatileLongFound && !this.firstDoubleOffset.add(J9Object.SIZEOF).bitAnd(4).eq(0L)) {
            this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_VOLATILE_PADDING_NEEDED);
            this.backfillOffset = IDATA.cast(this.firstDoubleOffset);
            this.firstDoubleOffset = this.firstDoubleOffset.add(4L);
        }
        this.firstObjectOffset = this.firstDoubleOffset.add(this.doubleCount.mult(8));
        this.firstSingleOffset = this.firstObjectOffset.add(this.objectCount.mult((int)ObjectReferencePointer.SIZEOF));
        this.instanceSize = this.firstSingleOffset.add(this.singleCount.mult(4));
        if (this.backfillOffset.gte(new IDATA(0L)) && !this.backfillEligibleFields.eq(0L)) {
            this.backfillOffsetToUse = this.backfillOffset;
            this.instanceSize = this.instanceSize.sub(4L);
            this.walkFlags = this.singleCount.gt(0) ? this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD) : this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD);
        }
        if (J9BuildFlags.env_data64 && this.instanceSize.add(J9Object.SIZEOF).anyBitsIn(4L)) {
            this.instanceSize = this.instanceSize.add(4L);
        }
    }

    public boolean hasNext() {
        if (this.romFieldsShapeIterator == null) {
            try {
                this.init();
            }
            catch (CorruptDataException e) {
                return false;
            }
        }
        return this.romFieldsShapeIterator.hasNext();
    }

    public J9ObjectFieldOffset next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            this.nextImpl();
            return new J9ObjectFieldOffset(this.field, this.offset);
        }
        catch (AddressedCorruptDataException e) {
            EventManager.raiseCorruptDataEvent("AddressedCorruptDataException getting next field offset.", e, false);
            return null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("CorruptDataException getting next field offset.", e, false);
            return null;
        }
    }
}

