/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.I16Pointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.structure.ClasspathWrapper;
import com.ibm.j9ddr.vm24.types.I16;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=ClasspathWrapper.class)
public class ClasspathWrapperPointer
extends StructurePointer {
    public static final ClasspathWrapperPointer NULL = new ClasspathWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ClasspathWrapperPointer(long address) {
        super(address);
    }

    public static ClasspathWrapperPointer cast(AbstractPointer structure) {
        return ClasspathWrapperPointer.cast(structure.getAddress());
    }

    public static ClasspathWrapperPointer cast(UDATA udata) {
        return ClasspathWrapperPointer.cast(udata.longValue());
    }

    public static ClasspathWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ClasspathWrapperPointer(address);
    }

    public ClasspathWrapperPointer add(long count) {
        return ClasspathWrapperPointer.cast(this.address + ClasspathWrapper.SIZEOF * count);
    }

    public ClasspathWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ClasspathWrapperPointer addOffset(long offset) {
        return ClasspathWrapperPointer.cast(this.address + offset);
    }

    public ClasspathWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public ClasspathWrapperPointer sub(long count) {
        return ClasspathWrapperPointer.cast(this.address - ClasspathWrapper.SIZEOF * count);
    }

    public ClasspathWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ClasspathWrapperPointer subOffset(long offset) {
        return ClasspathWrapperPointer.cast(this.address - offset);
    }

    public ClasspathWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ClasspathWrapperPointer untag(long mask) {
        return ClasspathWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ClasspathWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return ClasspathWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_classpathItemSizeOffset_", declaredType="U32")
    public U32 classpathItemSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(ClasspathWrapper._classpathItemSizeOffset_));
    }

    public U32Pointer classpathItemSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)ClasspathWrapper._classpathItemSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_staleFromIndexOffset_", declaredType="I16")
    public I16 staleFromIndex() throws CorruptDataException {
        return new I16(this.getShortAtOffset(ClasspathWrapper._staleFromIndexOffset_));
    }

    public I16Pointer staleFromIndexEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I16Pointer.cast(this.address + (long)ClasspathWrapper._staleFromIndexOffset_);
    }
}

