/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm24.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;

public class AllClassesCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public AllClassesCommand() {
        this.addCommand("allclasses", "", "Dump a list of all loaded classes");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            out.append("RAM classes (ram loader rom name)" + nl);
            out.append("Class addr\tClassLoader\tROM class addr\tClass name" + nl);
            out.append(nl);
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm, vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer classPointer = (J9ClassPointer)classSegmentIterator.next();
                out.append(classPointer.getHexAddress());
                out.append('\t');
                out.append(classPointer.classLoader().getHexAddress());
                out.append('\t');
                out.append(classPointer.romClass().getHexAddress());
                out.append('\t');
                out.append(J9ClassHelper.getJavaName(classPointer));
                out.append(nl);
            }
            out.append(nl);
            out.append("ROM classes (rom size loader modifiers name)" + nl);
            out.append("Class addr\tROM size\tClassLoader\tModifiers\tClass name" + nl);
            out.append(nl);
            ROMClassesIterator iterator = new ROMClassesIterator(out, vm.classMemorySegments());
            while (iterator.hasNext()) {
                J9ROMClassPointer classPointer = iterator.next();
                out.append(classPointer.getHexAddress());
                out.append('\t');
                out.append(classPointer.romSize().getHexValue());
                out.append('\t');
                out.append(iterator.getMemorySegmentPointer().classLoader().getHexAddress());
                out.append('\t');
                out.append(classPointer.modifiers().getHexValue());
                out.append('\t');
                out.append(J9UTF8Helper.stringValue(classPointer.className()));
                out.append(nl);
            }
            out.append(nl);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

