/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCJVMTIObjectTagTableIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCJVMTIObjectTagTableListIterator;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JVMTIDataPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckJVMTIObjectTagTables
extends Check {
    CheckJVMTIObjectTagTables() {
    }

    public void check() {
        try {
            J9JVMTIDataPointer jvmtiData = J9JVMTIDataPointer.cast(this.getJavaVM().jvmtiData());
            if (jvmtiData.notNull()) {
                GCJVMTIObjectTagTableListIterator objectTagTableList = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(jvmtiData);
                while (objectTagTableList.hasNext()) {
                    J9JVMTIEnvPointer list = objectTagTableList.next();
                    VoidPointer objectTagTable = VoidPointer.cast(list.objectTagTable());
                    GCJVMTIObjectTagTableIterator objectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                    while (objectTagTableIterator.hasNext()) {
                        PointerPointer slot = PointerPointer.cast(objectTagTableIterator.nextAddress());
                        if (!slot.notNull() || this._engine.checkSlotPool(slot, objectTagTable) == 0) continue;
                        return;
                    }
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "JVMTI OBJECT TAG TABLES";
    }

    public void print() {
        try {
            J9JVMTIDataPointer jvmtiData = J9JVMTIDataPointer.cast(this.getJavaVM().jvmtiData());
            if (jvmtiData.notNull()) {
                ScanFormatter formatter = new ScanFormatter(this, "jvmtiObjectTagTables", jvmtiData);
                GCJVMTIObjectTagTableListIterator objectTagTableList = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(jvmtiData);
                while (objectTagTableList.hasNext()) {
                    J9JVMTIEnvPointer list = objectTagTableList.next();
                    GCJVMTIObjectTagTableIterator objectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                    while (objectTagTableIterator.hasNext()) {
                        formatter.entry(objectTagTableIterator.next());
                    }
                }
                formatter.end("jvmtiObjectTagTables", jvmtiData);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

