/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckMonitorTable
extends Check {
    CheckMonitorTable() {
    }

    public void check() {
        try {
            GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
            J9HashTablePointer monitorTable = this._javaVM.monitorTable();
            while (monitorReferenceIterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitor = monitorReferenceIterator.next();
                J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(objectMonitor.monitor());
                PointerPointer slot = PointerPointer.cast(monitor.userDataEA());
                if (this._engine.checkSlotPool(slot, VoidPointer.cast(monitorTable)) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "MONITOR TABLE";
    }

    public void print() {
        try {
            GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "MonitorTable");
            while (monitorReferenceIterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitor = monitorReferenceIterator.next();
                J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(objectMonitor.monitor());
                formatter.entry(VoidPointer.cast(monitor.userData()));
            }
            formatter.end("MonitorTable");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

