/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckRememberedSet
extends Check {
    CheckRememberedSet() {
    }

    public void check() {
        try {
            if (!J9BuildFlags.gc_modronScavenger || !this._extensions.scavengerEnabled()) {
                return;
            }
            GCRememberedSetIterator remSetIterator = GCRememberedSetIterator.from();
            while (remSetIterator.hasNext()) {
                MM_SublistPuddlePointer puddle = remSetIterator.next();
                GCRememberedSetSlotIterator remSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
                while (remSetSlotIterator.hasNext()) {
                    PointerPointer objectIndirect = PointerPointer.cast(remSetSlotIterator.nextAddress());
                    if (this._engine.checkSlotRememberedSet(objectIndirect, puddle) == 0) continue;
                    return;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "REMEMBERED SET";
    }

    public void print() {
        try {
            GCRememberedSetIterator remSetIterator = GCRememberedSetIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "RememberedSet Sublist", this.getGCExtensions().rememberedSetEA());
            while (remSetIterator.hasNext()) {
                MM_SublistPuddlePointer puddle = remSetIterator.next();
                formatter.section("puddle", puddle);
                GCRememberedSetSlotIterator remSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
                while (remSetSlotIterator.hasNext()) {
                    formatter.entry(remSetSlotIterator.next());
                }
                formatter.endSection();
            }
            formatter.end("RememberedSet Sublist", this.getGCExtensions().rememberedSetEA());
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

