/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.j9.ObjectMonitor;
import com.ibm.j9ddr.vm24.j9.walkers.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.DoublePointer;
import com.ibm.j9ddr.vm24.pointer.FloatPointer;
import com.ibm.j9ddr.vm24.pointer.I16Pointer;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.I64Pointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.pointer.U16Pointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.U64Pointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9FieldFlags;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    private static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    private static final int DEFAULT_ARRAY_FORMAT_END = 16;

    @Override
    public FormatWalkResult format(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        if (type2.equalsIgnoreCase("j9object") || type2.equalsIgnoreCase("j9indexableobject")) {
            try {
                J9ObjectPointer object = J9ObjectPointer.cast(address);
                J9ClassPointer classAddr = J9ObjectHelper.clazz(object);
                if (classAddr.isNull()) {
                    out.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                J9ClassPointer clazz = classAddr;
                if (clazz.isNull()) {
                    out.println("<can not read RAM class>");
                    return FormatWalkResult.STOP_WALKING;
                }
                boolean isArray = J9ClassHelper.isArrayClass(clazz);
                String className = J9UTF8Helper.stringValue(clazz.romClass().className());
                if (className.equals("java/lang/String")) {
                    this.formatStringObject(out, object);
                } else if (isArray) {
                    int begin = 0;
                    int end = 16;
                    if (extraArgs.length > 0) {
                        begin = Integer.parseInt(extraArgs[0]);
                    }
                    if (extraArgs.length > 1) {
                        end = Integer.parseInt(extraArgs[1]);
                    }
                    this.formatArrayObject(out, J9IndexableObjectPointer.cast(object), begin, end);
                } else {
                    out.println(String.format("J9Object at %s {", object.getHexAddress()));
                    this.printJ9ObjectFields(out, object);
                    out.println("}");
                }
            }
            catch (CorruptDataException ex) {
                out.println("Error for ");
                ex.printStackTrace(out);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatArrayObject(PrintStream out, J9IndexableObjectPointer localObject, int begin, int end) throws CorruptDataException {
        J9ObjectMonitorPointer lockword;
        J9ObjectPointer j9object;
        ObjectMonitor monitor;
        String className = J9IndexableObjectHelper.getClassName(localObject);
        out.println(String.format("J9IndexableObject at %s {", localObject.getHexAddress()));
        out.println(String.format("    struct J9Class* clazz = !j9arrayclass %s   // %s", J9IndexableObjectHelper.clazz(localObject).getHexAddress(), className));
        out.println(String.format("    Object flags = %s;", J9IndexableObjectHelper.flags(localObject).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery && (monitor = ObjectMonitor.fromJ9Object(j9object = J9ObjectPointer.cast(localObject))) != null && (lockword = monitor.getLockword()) != null) {
            out.println(String.format("    j9objectmonitor_t monitor = %s;", lockword.getHexAddress()));
        }
        out.println(String.format("    U_32 size = %s;", J9IndexableObjectHelper.size(localObject).getHexValue()));
        if (J9BuildFlags.gc_arraylets) {
            out.println("<<gc_arraylets: Not implemented>>");
        } else {
            this.printSubArrayType(out, J9IndexableObjectHelper.size(localObject), UDATAPointer.cast(J9IndexableObjectPointer.cast(localObject).add(1L)), U8Pointer.cast(localObject).add(ObjectModel.getSizeInBytesWithHeader(J9ObjectPointer.cast(localObject))), J9IndexableObjectHelper.clazz(localObject), begin, end, localObject);
        }
        out.println("}");
    }

    void printSubArrayType(PrintStream out, U32 size, UDATAPointer cursor, U8Pointer limit, J9ArrayClassPointer classData, int begin, int end, J9IndexableObjectPointer address) throws CorruptDataException {
        J9ArrayClassPointer instanceClass = classData;
        J9ROMClassPointer instanceRomClass = instanceClass.romClass();
        String nameUTF = J9UTF8Helper.stringValue(instanceRomClass.className());
        if (begin < end) {
            switch (nameUTF.charAt(1)) {
                case 'B': 
                case 'Z': {
                    int slot;
                    cursor = UDATAPointer.cast(U8Pointer.cast(cursor.getAddress()).add(begin * 1));
                    if (cursor.gte(limit)) {
                        return;
                    }
                    for (slot = begin; cursor.lt(limit) && slot < end; ++slot) {
                        out.print(String.format("    [%d] = %3d, 0x%02x", slot, U8Pointer.cast(cursor).at(0L).longValue(), U8Pointer.cast(cursor).at(0L).longValue()));
                        out.println();
                        cursor = UDATAPointer.cast(U8Pointer.cast(cursor).add(1L));
                    }
                    break;
                }
                case 'C': {
                    int slot;
                    cursor = UDATAPointer.cast(U16Pointer.cast(cursor.getAddress()).add(begin));
                    if (cursor.gte(limit)) {
                        return;
                    }
                    while (cursor.lt(limit) && slot < end) {
                        long value = U16Pointer.cast(cursor).at(0L).longValue();
                        out.print(String.format("    [%d] = %5d, 0x%2$04x, '%c'", slot, value, Character.valueOf((char)value)));
                        out.println();
                        cursor = UDATAPointer.cast(U16Pointer.cast(cursor).add(1L));
                        ++slot;
                    }
                    break;
                }
                case 'S': {
                    int slot;
                    cursor = UDATAPointer.cast(I16Pointer.cast(cursor.getAddress()).add(begin));
                    if (cursor.gte(limit)) {
                        return;
                    }
                    while (cursor.lt(limit) && slot < end) {
                        out.print(String.format("    [%d] = %6d, 0x%04x", slot, I16Pointer.cast(cursor).at(0L).longValue(), U16Pointer.cast(cursor).at(0L).longValue()));
                        out.println();
                        cursor = UDATAPointer.cast(I16Pointer.cast(cursor).add(1L));
                        ++slot;
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    int slot;
                    cursor = UDATAPointer.cast(U32Pointer.cast(cursor.getAddress()).add(begin));
                    if (cursor.gte(limit)) {
                        return;
                    }
                    while (cursor.lt(limit) && slot < end) {
                        out.print(String.format("    [%d] = %10d, 0x%08x, %8.8fF", slot, I32Pointer.cast(cursor).at(0L).longValue(), U32Pointer.cast(cursor).at(0L).longValue(), Float.valueOf(FloatPointer.cast(cursor).floatAt(0L))));
                        out.println();
                        cursor = UDATAPointer.cast(I32Pointer.cast(cursor).add(1L));
                        ++slot;
                    }
                    break;
                }
                case 'D': 
                case 'J': {
                    int slot;
                    cursor = UDATAPointer.cast(U64Pointer.cast(cursor.getAddress()).add(begin));
                    if (cursor.gte(limit)) {
                        return;
                    }
                    while (cursor.lt(limit) && slot < end) {
                        out.println(String.format("    [%d] = %2d, 0x%016x, %8.8fF", slot, I64Pointer.cast(cursor).at(0L).longValue(), I64Pointer.cast(cursor).at(0L).longValue(), DoublePointer.cast(cursor).doubleAt(0L)));
                        cursor = UDATAPointer.cast(I64Pointer.cast(cursor).add(1L));
                        ++slot;
                    }
                    break;
                }
                default: {
                    int slot;
                    AbstractPointer localCursor = J9BuildFlags.gc_compressedPointers ? I32Pointer.cast(cursor).add(begin) : UDATAPointer.cast(cursor).add(begin);
                    while (localCursor.lt(limit) && slot < end) {
                        if (((AbstractPointer)localCursor).at(0L).longValue() != 0L) {
                            out.println(String.format("    [%d] = !fj9object 0x%x", slot, ((AbstractPointer)localCursor).at(0L).longValue()));
                        } else {
                            out.println(String.format("    [%d] = null", slot));
                        }
                        localCursor = ((AbstractPointer)localCursor).add(1L);
                        ++slot;
                    }
                    break block0;
                }
            }
            if (begin > 0 || size.gt(end)) {
                out.println(String.format("To print entire range: !j9indexableobject %s %d %d\n", address.getHexAddress(), 0, size.longValue()));
            }
        }
    }

    private void formatStringObject(PrintStream out, J9ObjectPointer localObject) throws CorruptDataException {
        out.println(String.format("J9VMJavaLangString at %s {\n", localObject.getHexAddress()));
        this.printJ9ObjectFields(out, localObject);
        out.println(String.format("    \"%s\"\n", J9ObjectHelper.stringValue(localObject)));
        out.println("}");
    }

    private void printJ9ObjectFields(PrintStream out, J9ObjectPointer localObject) throws CorruptDataException {
        J9ObjectMonitorPointer lockword;
        J9ObjectPointer j9object;
        ObjectMonitor monitor;
        J9ClassPointer instanceClass = J9ObjectHelper.clazz(localObject);
        J9UTF8Pointer classNameUTF = instanceClass.romClass().className();
        J9ClassPointer previousSuperclass = J9ClassPointer.NULL;
        out.println(String.format("    struct J9Class* clazz = !j9class %s   // %s", J9ObjectHelper.clazz(localObject).getHexAddress(), J9UTF8Helper.stringValue(classNameUTF)));
        out.println(String.format("    Object flags = %s;", J9ObjectHelper.flags(localObject).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery && (monitor = ObjectMonitor.fromJ9Object(j9object = J9ObjectPointer.cast(localObject))) != null && (lockword = monitor.getLockword()) != null) {
            out.println(String.format("    j9objectmonitor_t monitor = %s;", lockword.getHexAddress()));
        }
        long depth = J9ClassHelper.depth(instanceClass);
        for (long superclassIndex = 0L; superclassIndex <= depth; ++superclassIndex) {
            J9ClassPointer superclass = superclassIndex == depth ? instanceClass : J9ClassPointer.cast(instanceClass.superclasses().at(superclassIndex));
            U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass, previousSuperclass, flags);
            while (iterator.hasNext()) {
                J9ObjectFieldOffset result = iterator.next();
                if (result.getField().modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
                this.printObjectField(out, localObject, superclass, result.getField(), result.getOffsetOrAddress());
            }
            previousSuperclass = superclass;
        }
    }

    private void printObjectField(PrintStream out, J9ObjectPointer localObject, J9ClassPointer fromClass, J9ROMFieldShapePointer field, UDATA offset) throws CorruptDataException {
        J9UTF8Pointer className = fromClass.romClass().className();
        J9UTF8Pointer nameUTF = field.nameAndSignature().name();
        J9UTF8Pointer sigUTF = field.nameAndSignature().signature();
        U8Pointer valuePtr = U8Pointer.cast(localObject).add(offset).add(J9Object.SIZEOF);
        out.print(String.format("    %s %s = ", J9UTF8Helper.stringValue(sigUTF), J9UTF8Helper.stringValue(nameUTF)));
        if (field.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            out.print(U64Pointer.cast(valuePtr).at(0L).getHexValue());
        } else if (field.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            Pointer ptr = J9BuildFlags.gc_compressedPointers ? U32Pointer.cast(valuePtr) : UDATAPointer.cast(valuePtr);
            out.print(String.format("!fj9object 0x%x", ptr.at(0L).longValue()));
        } else {
            out.print(I32Pointer.cast(valuePtr).at(0L).getHexValue());
        }
        out.print(String.format(" (offset=%d) (%s)", offset.longValue(), J9UTF8Helper.stringValue(className)));
        out.println();
    }
}

