/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.SimpleRootScanner;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSet {
    private static RootSet[] _singletons = new RootSet[RootSetType.values().length];
    private ArrayList<J9ObjectPointer> _allRoots = new ArrayList();
    private ArrayList<VoidPointer> _allAddresses = new ArrayList();

    private RootSet(RootSetType rootSetType) throws CorruptDataException {
        RootSetScanner rootSetScanner = new RootSetScanner();
        switch (rootSetType) {
            case ALL: {
                rootSetScanner.scanAllSlots();
                break;
            }
            case STRONG_REACHABLE: {
                rootSetScanner.scanRoots();
                break;
            }
            case WEAK_REACHABLE: {
                rootSetScanner.scanClearable();
                break;
            }
            case ALL_SLOTS_EXCLUDING_STACK_SLOTS: {
                rootSetScanner.setScanStackSlots(false);
                rootSetScanner.scanAllSlots();
                break;
            }
            case STRONG_REACHABLE_EXCLUDING_STACK_SLOTS: {
                rootSetScanner.setScanStackSlots(false);
                rootSetScanner.scanRoots();
            }
            default: {
                throw new UnsupportedOperationException("Invalid rootSetType");
            }
        }
    }

    protected static RootSet from(RootSetType rootSetType, boolean useSingleton) throws CorruptDataException {
        RootSet rootSetToReturn = useSingleton ? (null == _singletons[rootSetType.getValue()] ? new RootSet(rootSetType) : _singletons[rootSetType.getValue()]) : new RootSet(rootSetType);
        if (null == _singletons[rootSetType.getValue()]) {
            RootSet._singletons[rootSetType.getValue()] = rootSetToReturn;
        }
        return rootSetToReturn;
    }

    public static List<J9ObjectPointer> allRoots(RootSetType rootSetType) throws CorruptDataException {
        RootSet rootSet = new RootSet(rootSetType);
        return Collections.unmodifiableList(rootSet._allRoots);
    }

    public GCIterator gcIterator(RootSetType rootSetType) throws CorruptDataException {
        final Iterator<J9ObjectPointer> rootSetIterator = this._allRoots.iterator();
        final Iterator<VoidPointer> rootSetAddressIterator = this._allAddresses.iterator();
        return new GCIterator(){

            public boolean hasNext() {
                return rootSetIterator.hasNext();
            }

            public VoidPointer nextAddress() {
                rootSetIterator.next();
                return (VoidPointer)rootSetAddressIterator.next();
            }

            public Object next() {
                rootSetAddressIterator.next();
                return rootSetIterator.next();
            }
        };
    }

    public static GCIterator rootIterator(RootSetType rootSetType) throws CorruptDataException {
        RootSet rootSet = RootSet.from(rootSetType, true);
        return rootSet.gcIterator(rootSetType);
    }

    private class RootSetScanner
    extends SimpleRootScanner {
        protected RootSetScanner() throws CorruptDataException {
        }

        protected void doClassSlot(J9ClassPointer slot, VoidPointer address) {
            if (slot.notNull()) {
                this.doClass(slot, address);
            }
        }

        protected void doSlot(J9ObjectPointer slot, VoidPointer address) {
            if (slot.notNull()) {
                RootSet.this._allRoots.add(slot);
                RootSet.this._allAddresses.add(address);
            }
        }

        protected void doClass(J9ClassPointer slot, VoidPointer address) {
            J9ObjectPointer classObject = J9ObjectPointer.NULL;
            VoidPointer classObjectSlot = VoidPointer.NULL;
            try {
                classObject = slot.classObject();
                classObjectSlot = VoidPointer.cast(slot.classObjectEA());
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Class: " + slot.getHexAddress() + " has invalid classObject slot", cde, false);
                return;
            }
            this.doSlot(classObject, classObjectSlot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RootSetType {
        ALL(0),
        STRONG_REACHABLE(1),
        WEAK_REACHABLE(2),
        ALL_SLOTS_EXCLUDING_STACK_SLOTS(3),
        STRONG_REACHABLE_EXCLUDING_STACK_SLOTS(4);

        private final int value;

        private RootSetType(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

