/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.j9.gc.GCHeapMap;
import com.ibm.j9ddr.vm26.j9.gc.GCMarkMap;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_HeapMapPointer;
import com.ibm.j9ddr.vm26.structure.MM_CompactScheme;
import com.ibm.j9ddr.vm26.structure.MM_HeapMap;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.ArrayList;

public class GCMarkMapStandard
extends GCMarkMap {
    public GCMarkMapStandard(MM_HeapMapPointer heapMap) throws CorruptDataException {
        super(heapMap);
    }

    public int getPageSize(J9ObjectPointer object) {
        int result = super.getPageSize(object);
        try {
            UDATA heapBaseOffset;
            UDATA pageIndex;
            UDATA compactTableEntry_addr;
            if (object != null && object.gte(this._heapBase) && object.lt(this._heapTop) && (compactTableEntry_addr = this._heapMapBits.at(pageIndex = (heapBaseOffset = UDATA.cast(object).sub(UDATA.cast(this._heapBase))).div(MM_CompactScheme.sizeof_page).mult(2))).allBitsIn(3L)) {
                result = (int)MM_CompactScheme.sizeof_page;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        return result;
    }

    public GCHeapMap.MarkedObject[] queryRange(J9ObjectPointer base, J9ObjectPointer top) throws CorruptDataException {
        ArrayList<GCHeapMap.MarkedObject> results = new ArrayList<GCHeapMap.MarkedObject>();
        if (base.lt(this._heapBase)) {
            base = J9ObjectPointer.cast(this._heapBase);
        }
        if (top.gt(this._heapTop)) {
            top = J9ObjectPointer.cast(this._heapTop);
        }
        if (base.gt(top)) {
            base = top;
        }
        J9ObjectPointer cursor = base;
        while (cursor.lt(top)) {
            UDATA heapBaseOffset = UDATA.cast(cursor).sub(UDATA.cast(this._heapBase));
            UDATA pageIndex = heapBaseOffset.div(MM_CompactScheme.sizeof_page).mult(2);
            UDATA compactTableEntry_addr = this._heapMapBits.at(pageIndex);
            UDATA compactTableEntry_bits = this._heapMapBits.at(pageIndex.add(1L));
            if (compactTableEntry_addr.allBitsIn(3L)) {
                J9ObjectPointer newObject = J9ObjectPointer.cast(compactTableEntry_addr.bitAnd(-4));
                UDATA bits = compactTableEntry_bits;
                UDATA offset = heapBaseOffset.mod(MM_CompactScheme.sizeof_page).div(2L * MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * (long)UDATA.SIZEOF);
                UDATA bitMask = new UDATA(1L).leftShift(offset);
                if (bits.bitAnd(bitMask).eq(bitMask)) {
                    int i;
                    long mask = 1L;
                    int ordinal = 0;
                    for (i = offset.intValue(); i > 0; --i) {
                        if (bits.allBitsIn(mask)) {
                            ++ordinal;
                        }
                        mask <<= 1;
                    }
                    for (i = 0; i < ordinal; ++i) {
                        UDATA objectSize = ObjectModel.getConsumedSizeInBytesWithHeader(newObject);
                        newObject = newObject.addOffset(objectSize);
                    }
                    results.add(new GCHeapMap.MarkedObject(cursor, this._heapMapBits.add(pageIndex), newObject));
                }
                cursor = cursor.addOffset(this.getObjectGrain() * 2);
                continue;
            }
            UDATA[] indexAndMask = this.getSlotIndexAndMask(cursor);
            UDATAPointer slot = this._heapMapBits.add(indexAndMask[0]);
            if (slot.at(0L).bitAnd(indexAndMask[1]).gt(0)) {
                results.add(new GCHeapMap.MarkedObject(cursor, slot));
            }
            cursor = cursor.addOffset(this.getObjectGrain());
        }
        return results.toArray(new GCHeapMap.MarkedObject[results.size()]);
    }
}

