/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.Pointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

public class PointerPointer
extends Pointer {
    public static final PointerPointer NULL = new PointerPointer(0L);

    protected PointerPointer(long address) {
        super(address);
    }

    public static PointerPointer cast(AbstractPointer pointer) {
        return PointerPointer.cast(pointer.getAddress());
    }

    public static PointerPointer cast(UDATA udata) {
        return PointerPointer.cast(udata.longValue());
    }

    public static PointerPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new PointerPointer(address);
    }

    public VoidPointer at(long index) throws CorruptDataException {
        return new VoidPointer(this.getPointerAtOffset(index * SIZEOF));
    }

    public VoidPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public PointerPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    public PointerPointer untag(long mask) {
        return new PointerPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public PointerPointer add(long count) {
        return new PointerPointer(this.address + SIZEOF * count);
    }

    public PointerPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public PointerPointer addOffset(long offset) {
        return new PointerPointer(this.address + offset);
    }

    public PointerPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public PointerPointer sub(long count) {
        return new PointerPointer(this.address - SIZEOF * count);
    }

    public PointerPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public PointerPointer subOffset(long offset) {
        return new PointerPointer(this.address - offset);
    }

    public PointerPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return DataType.process.bytesPerPointer();
    }
}

