/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.generated.PortLibraryPointer;
import com.ibm.j9ddr.vm26.structure.Storage;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=Storage.class)
public class StoragePointer
extends StructurePointer {
    public static final StoragePointer NULL = new StoragePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected StoragePointer(long address) {
        super(address);
    }

    public static StoragePointer cast(AbstractPointer structure) {
        return StoragePointer.cast(structure.getAddress());
    }

    public static StoragePointer cast(UDATA udata) {
        return StoragePointer.cast(udata.longValue());
    }

    public static StoragePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new StoragePointer(address);
    }

    public StoragePointer add(long count) {
        return StoragePointer.cast(this.address + Storage.SIZEOF * count);
    }

    public StoragePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public StoragePointer addOffset(long offset) {
        return StoragePointer.cast(this.address + offset);
    }

    public StoragePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public StoragePointer sub(long count) {
        return StoragePointer.cast(this.address - Storage.SIZEOF * count);
    }

    public StoragePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public StoragePointer subOffset(long offset) {
        return StoragePointer.cast(this.address - offset);
    }

    public StoragePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public StoragePointer untag(long mask) {
        return StoragePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public StoragePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return Storage.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="__portLibOffset_", declaredType="class PortLibrary*")
    public PortLibraryPointer _portLib() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(Storage.__portLibOffset_);
        return PortLibraryPointer.cast(pointer);
    }

    public PointerPointer _portLibEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)Storage.__portLibOffset_);
    }
}

