/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.commands.SegmentsUtil;
import java.io.PrintStream;

public class DumpSegmentsInListCommand
extends Command {
    public DumpSegmentsInListCommand() {
        this.addCommand("dumpsegmentsinlist", "<segmentlist>", "dump all segments in segmentlist");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9MemorySegmentListPointer list = J9MemorySegmentListPointer.cast(address);
            SegmentsUtil.dbgDumpSegmentList(out, list);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

