/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm26.pointer.U16Pointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.U64Pointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import java.io.PrintStream;

public class EnumFormatter
extends BaseFieldFormatter {
    public FormatWalkResult format(String name, String type2, String declaredType, int typeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        long value;
        if (typeCode != 101) {
            return FormatWalkResult.KEEP_WALKING;
        }
        type2 = type2.replace("enum", "");
        StructureReader.StructureDescriptor desc = StructureCommandUtil.getStructureDescriptor(type2 = type2.trim(), context);
        if (null == desc) {
            out.print("<<Missing description of " + type2 + ">>");
            return FormatWalkResult.STOP_WALKING;
        }
        switch (desc.getSizeOf()) {
            case 1: {
                value = U8Pointer.cast(address).at(0L).longValue();
                break;
            }
            case 2: {
                value = U16Pointer.cast(address).at(0L).longValue();
                break;
            }
            case 4: {
                value = U32Pointer.cast(address).at(0L).longValue();
                break;
            }
            case 8: {
                value = U64Pointer.cast(address).at(0L).longValue();
                break;
            }
            default: {
                out.print("<<Unhandled enum size: " + desc.getSizeOf() + ">>");
                return FormatWalkResult.STOP_WALKING;
            }
        }
        out.print("0x" + Long.toHexString(value));
        out.print(" (");
        out.print(value);
        out.print(")");
        boolean mnemonicWritten = false;
        for (StructureReader.ConstantDescriptor constant : desc.getConstants()) {
            if (constant.getValue() != value) continue;
            out.print(" //");
            out.print(constant.getName());
            mnemonicWritten = true;
            break;
        }
        if (!mnemonicWritten) {
            out.print(" <<Not matched to enum constant>>");
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

