/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm26.types.I16;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.I64;
import com.ibm.j9ddr.vm26.types.I8;
import com.ibm.j9ddr.vm26.types.IScalar;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UScalar;

public class U64
extends UScalar {
    public static final int SIZEOF = 8;
    public static final long MASK = -1L;
    public static final U64 MIN = new U64(0L);
    public static final U64 MAX = new U64(-1L);

    public U64(long value) {
        super(value);
    }

    public U64(Scalar parameter) {
        super(parameter);
    }

    public U64 add(int number) {
        return new U64(this.data + (long)number);
    }

    public U64 add(UScalar parameter) {
        return this.add(new U64(parameter));
    }

    public U64 add(U64 parameter) {
        return new U64(this.data + parameter.data);
    }

    public U64 add(IScalar parameter) {
        return this.add(new U64(parameter));
    }

    public U64 sub(int number) {
        return new U64(this.data - (long)number);
    }

    public U64 sub(UScalar parameter) {
        return this.sub(new U64(parameter));
    }

    public U64 sub(U64 parameter) {
        return new U64(this.data - parameter.data);
    }

    public U64 sub(I8 parameter) {
        return this.sub(new U64(parameter));
    }

    public U64 sub(I16 parameter) {
        return this.sub(new U64(parameter));
    }

    public U64 sub(I32 parameter) {
        return this.sub(new U64(parameter));
    }

    public U64 sub(I64 parameter) {
        return this.sub(new U64(parameter));
    }

    public int intValue() {
        if (super.intValue() < 0) {
            throw new InvalidDataTypeException("U_64 contains value larger than Integer.MAX_VALUE");
        }
        return super.intValue();
    }

    public long longValue() {
        if (super.longValue() < 0L) {
            throw new InvalidDataTypeException("U_64 contains value larger than Long.MAX_VALUE");
        }
        return super.longValue();
    }

    public U64 bitOr(int number) {
        return new U64(this.data | (long)number);
    }

    public U64 bitOr(long number) {
        return new U64(this.data | number);
    }

    public U64 bitOr(UScalar parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitOr(U64 parameter) {
        return new U64(this.data | parameter.data);
    }

    public U64 bitOr(I8 parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitOr(I16 parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitOr(I32 parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitOr(I64 parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitXor(int number) {
        return new U64(this.data ^ (long)number);
    }

    public U64 bitXor(long number) {
        return new U64(this.data ^ number);
    }

    public U64 bitXor(Scalar parameter) {
        return this.bitXor(new U64(parameter));
    }

    public U64 bitXor(U64 parameter) {
        return new U64(this.data ^ parameter.data);
    }

    public U64 bitAnd(int number) {
        return new U64(this.data & (long)number);
    }

    public U64 bitAnd(long number) {
        return new U64(this.data & number);
    }

    public U64 bitAnd(UScalar parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public U64 bitAnd(U64 parameter) {
        return new U64(this.data & parameter.data);
    }

    public U64 bitAnd(I8 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public U64 bitAnd(I16 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public U64 bitAnd(I32 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public U64 bitAnd(I64 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public boolean gt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        if (((this.data ^ parameter.data) & Long.MIN_VALUE) != 0L) {
            return this.data < parameter.data;
        }
        return this.data > parameter.data;
    }

    public boolean lt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        if (((this.data ^ parameter.data) & Long.MIN_VALUE) != 0L) {
            return this.data > parameter.data;
        }
        return this.data < parameter.data;
    }

    public U64 leftShift(int i) {
        return new U64(this.data << i);
    }

    public U64 rightShift(int i) {
        return new U64(this.data >>> i);
    }

    public U64 bitNot() {
        return new U64(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public U64 mult(int parameter) {
        return new U64(this.data * (long)parameter);
    }

    public boolean eq(Scalar parameter) {
        if (parameter instanceof U64) {
            return this.data == parameter.data;
        }
        if (parameter.isSigned()) {
            return this.eq(new U64(parameter));
        }
        if (this.data < 0L) {
            return false;
        }
        return this.longValue() == parameter.longValue();
    }

    public int sizeof() {
        return 8;
    }
}

