/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.view.dtfj.java;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.j9ddr.vm26.view.dtfj.java.DTFJJavaRuntimeMemorySectionBase;

public class DTFJGenericJavaRuntimeMemorySection
extends DTFJJavaRuntimeMemorySectionBase {
    private final long baseAddress;
    private final long size;
    private final int allocationType;
    private final String allocator;
    private final JavaRuntimeMemoryCategory category;
    private final String name;

    public DTFJGenericJavaRuntimeMemorySection(long baseAddress, long size, int allocationType, String name, String allocator, JavaRuntimeMemoryCategory category) {
        this.baseAddress = baseAddress;
        this.size = size;
        this.allocationType = allocationType;
        this.name = name;
        this.allocator = allocator;
        this.category = category;
    }

    DTFJGenericJavaRuntimeMemorySection(long baseAddress, long size, int allocationType, String name) {
        this(baseAddress, size, allocationType, name, null, null);
    }

    protected long getBaseAddressAsLong() {
        return this.baseAddress;
    }

    public int getAllocationType() {
        return this.allocationType;
    }

    public String getAllocator() throws CorruptDataException, DataUnavailable {
        if (this.allocator != null) {
            return this.allocator;
        }
        throw new DataUnavailable();
    }

    public JavaRuntimeMemoryCategory getMemoryCategory() throws CorruptDataException, DataUnavailable {
        if (this.category != null) {
            return this.category;
        }
        throw new DataUnavailable();
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.allocationType;
        result = 31 * result + (this.allocator == null ? 0 : this.allocator.hashCode());
        result = 31 * result + (int)(this.baseAddress ^ this.baseAddress >>> 32);
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DTFJGenericJavaRuntimeMemorySection)) {
            return false;
        }
        DTFJGenericJavaRuntimeMemorySection other = (DTFJGenericJavaRuntimeMemorySection)obj;
        if (this.allocationType != other.allocationType) {
            return false;
        }
        if (this.allocator == null ? other.allocator != null : !this.allocator.equals(other.allocator)) {
            return false;
        }
        if (this.baseAddress != other.baseAddress) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.size == other.size;
    }
}

