/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.view.dtfj.java;

import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaFieldHelper;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm26.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm26.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm26.view.dtfj.java.DTFJJavaObject;

public class DTFJJavaFieldInstance
extends DTFJJavaField {
    public DTFJJavaFieldInstance(DTFJJavaClass clazz, J9ObjectFieldOffset ptr) throws CorruptDataException {
        super(clazz, ptr);
    }

    public Object get(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    return this.getBoolean(object);
                }
                case 'B': {
                    return this.getByte(object);
                }
                case 'C': {
                    return Character.valueOf(this.getChar(object));
                }
                case 'S': {
                    return this.getShort(object);
                }
                case 'I': {
                    return this.getInt(object);
                }
                case 'F': {
                    return new Float(this.getFloat(object));
                }
                case 'J': {
                    return this.getLong(object);
                }
                case 'D': {
                    return new Double(this.getDouble(object));
                }
                case 'L': 
                case '[': {
                    DTFJJavaObject jobj = this.validateJavaObject(object);
                    this.checkDataTypeConversion(jobj, 768);
                    J9ObjectPointer data = J9ObjectHelper.getObjectField(jobj.getJ9ObjectPointer(), this.fieldOffset);
                    if (data.isNull()) {
                        return null;
                    }
                    return new DTFJJavaObject(null, data);
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data type");
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public boolean getBoolean(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            this.checkDataTypeConversion(jobj, 1);
            boolean data = J9ObjectHelper.getBooleanField(jobj.getJ9ObjectPointer(), this.fieldOffset);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public byte getByte(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 2);
            return (byte)data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public char getChar(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            this.checkDataTypeConversion(jobj, 8);
            char data = J9ObjectHelper.getCharField(jobj.getJ9ObjectPointer(), this.fieldOffset);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public double getDouble(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 254);
            return Double.longBitsToDouble(data);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public float getFloat(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 126);
            return Float.intBitsToFloat((int)data);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public int getInt(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 30);
            return (int)data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public long getLong(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 94);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public short getShort(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            long data = this.checkDataTypeConversion(jobj, 6);
            return (short)data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public String getString(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == object) {
            throw new NullPointerException("JavaObject is null");
        }
        if (!DTFJJavaFieldHelper.fieldIsString(this)) {
            throw new IllegalArgumentException("JavaField.getString() called on non-String field.");
        }
        try {
            DTFJJavaObject jobj = this.validateJavaObject(object);
            this.checkDataTypeConversion(jobj, 512);
            String data = J9ObjectHelper.getStringField(jobj.getJ9ObjectPointer(), this.fieldOffset);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public boolean isNestedPacked() {
        return false;
    }

    public boolean isNestedPackedArray() {
        return false;
    }

    public int getPackedLengthAnnotationValue() {
        return 0;
    }
}

