/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.MonitorTable;
import com.ibm.j9ddr.vm27.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MonitorTableListEntryPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9MonitorTableListEntryHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.types.U32;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorTableList {
    protected static MonitorTable[] monitorTables = null;
    protected static HashMap<J9TenantNativeDataPointer, MonitorTable> tenantMonitorTableCache = null;
    protected static boolean initialized = false;
    private static final String JAVA_LANG_CLASS_CLASSNAME = "java/lang/Class";
    private static final String JAVA_LANG_STRING_CLASSNAME = "java/lang/String";

    public static MonitorTableList from() throws CorruptDataException {
        return new MonitorTableList();
    }

    public MonitorTableListIterator iterator() throws CorruptDataException {
        return new MonitorTableListIterator();
    }

    public static Set<J9ObjectMonitorPointer> peek(J9ObjectPointer object) throws CorruptDataException {
        HashSet<J9ObjectMonitorPointer> hashSet = new HashSet<J9ObjectMonitorPointer>();
        if (!initialized) {
            MonitorTableList.initializeCaches();
        }
        for (J9TenantNativeDataPointer tenant : tenantMonitorTableCache.keySet()) {
            J9ObjectMonitorPointer objectMonitorPointer = MonitorTableList.peek(object, tenant);
            if (!objectMonitorPointer.notNull()) continue;
            hashSet.add(objectMonitorPointer);
        }
        J9ObjectMonitorPointer objectMonitorPointer = MonitorTableList.peek(object, J9TenantNativeDataPointer.NULL);
        if (objectMonitorPointer.notNull()) {
            hashSet.add(objectMonitorPointer);
        }
        return hashSet;
    }

    public static J9ObjectMonitorPointer peek(J9ObjectPointer object, J9TenantNativeDataPointer tenantScope) throws CorruptDataException {
        boolean isStringOrClass;
        if (null == object || object.isNull()) {
            return J9ObjectMonitorPointer.NULL;
        }
        MonitorTable table = null;
        if (!initialized) {
            MonitorTableList.initializeCaches();
        }
        J9ObjectMonitorPointer objectMonitor = J9ObjectMonitorPointer.NULL;
        if (null == tenantScope) {
            return objectMonitor;
        }
        String className = J9ObjectHelper.getClassName(object);
        boolean bl = isStringOrClass = JAVA_LANG_STRING_CLASSNAME.equals(className) || JAVA_LANG_CLASS_CLASSNAME.equals(className);
        if (tenantScope.notNull() && isStringOrClass) {
            table = tenantMonitorTableCache.get(tenantScope);
        } else {
            long hashcode = new U32(ObjectModel.getObjectHashCode(object)).longValue();
            int index = (int)(hashcode % (long)monitorTables.length);
            table = monitorTables[index];
        }
        if (table == null) {
            return objectMonitor;
        }
        if (null != table && null == (objectMonitor = table.peek(object))) {
            return J9ObjectMonitorPointer.NULL;
        }
        return objectMonitor;
    }

    private static void initializeTenantMonitorTableCache() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9MonitorTableListEntryPointer cursor = vm.monitorTableList();
        tenantMonitorTableCache = new HashMap();
        while (cursor.notNull()) {
            J9TenantNativeDataPointer tenant = J9MonitorTableListEntryHelper.getTenant(cursor);
            if (tenant.notNull()) {
                tenantMonitorTableCache.put(tenant, MonitorTable.from(cursor));
            }
            cursor = cursor.next();
        }
    }

    private static void initializeMonitorTables() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        PointerPointer cursor = vm.monitorTables();
        int count = vm.monitorTableCount().intValue();
        monitorTables = new MonitorTable[count];
        block0: for (int i = 0; i < count; ++i) {
            J9MonitorTableListEntryPointer entries = vm.monitorTableList();
            while (entries.notNull()) {
                if (entries.monitorTable().eq(cursor.at(i))) {
                    MonitorTableList.monitorTables[i] = MonitorTable.from(entries);
                    continue block0;
                }
                entries = entries.next();
            }
        }
    }

    private static synchronized void initializeCaches() throws CorruptDataException {
        if (!initialized) {
            MonitorTableList.initializeMonitorTables();
            MonitorTableList.initializeTenantMonitorTableCache();
            initialized = true;
        }
    }
}

