/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm27.pointer.NestedPackedObjectDataPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

public final class ObjectModel {
    protected static final GCObjectModel gcObjectModel;

    private ObjectModel() {
    }

    public static UDATA adjustSizeInBytes(UDATA sizeInBytes) {
        return gcObjectModel.adjustSizeInBytes(sizeInBytes);
    }

    public static UDATA getClassShape(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getClassShape(object);
    }

    public static UDATA getClassShape(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.getClassShape(clazz);
    }

    public static boolean isIndexable(J9ObjectPointer object) throws CorruptDataException {
        if (object instanceof NestedPackedObjectDataPointer) {
            return true;
        }
        return gcObjectModel.isIndexable(object);
    }

    public static boolean isIndexable(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.isIndexable(clazz);
    }

    public static boolean isDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isDeadObject(object);
    }

    public static boolean isSingleSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isSingleSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesMultiSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer object) {
        return gcObjectModel.getSizeInBytesSingleSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesDeadObject(object);
    }

    public static UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesWithHeader(object);
    }

    public static UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getConsumedSizeInBytesWithHeader(object);
    }

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getSizeInBytesWithHeader(object));
    }

    public UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getConsumedSizeInBytesWithHeader(object));
    }

    public static U32 getAge(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getAge(object);
    }

    public static boolean isRemembered(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isRemembered(object);
    }

    public static UDATA getRememberedBits(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getRememberedBits(object);
    }

    public static boolean isOld(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isOld(object);
    }

    public static UDATA getSizeInElements(J9ObjectPointer object) throws IllegalArgumentException, CorruptDataException {
        return gcObjectModel.getSizeInElements(object);
    }

    public static long getScanType(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getScanType(object);
    }

    public static boolean hasBeenHashed(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.hasBeenHashed(object);
    }

    public static boolean hasBeenMoved(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.hasBeenMoved(object);
    }

    public static I32 getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getObjectHashCode(object);
    }

    public static UDATA getHashcodeOffset(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getHashcodeOffset(object);
    }

    public static UDATA getHeaderSize(J9ObjectPointer object) throws CorruptDataException {
        if (object instanceof NestedPackedObjectDataPointer) {
            return new UDATA(0L);
        }
        return gcObjectModel.getHeaderSize(object);
    }

    public static VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        return gcObjectModel.getElementAddress(indexableObjectPointer, elementIndex, elementSize);
    }

    public static J9ObjectPointer getTargetObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getTargetObject(object);
    }

    public static UDATA getTargetOffset(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getTargetOffset(object);
    }

    public static UDATA getPackedDataSize(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getPackedDataSize(object);
    }

    public static UDATA getPackedDataSize(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.getPackedDataSize(clazz);
    }

    public static boolean isPackedObjectHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isPackedObjectHeader(object);
    }

    static {
        GCObjectModel objectModel = null;
        try {
            objectModel = GCObjectModel.from();
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error initializing the object model", cde, true);
            objectModel = null;
        }
        gcObjectModel = objectModel;
    }
}

