/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.AddressAwareRootScanner;
import com.ibm.j9ddr.vm27.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm27.pointer.ObjectMonitorReferencePointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadAbstractMonitorPointer;

abstract class SimpleRootScanner
extends AddressAwareRootScanner {
    protected SimpleRootScanner() throws CorruptDataException {
    }

    protected abstract void doSlot(J9ObjectPointer var1, VoidPointer var2);

    protected abstract void doClass(J9ClassPointer var1, VoidPointer var2);

    protected abstract void doClassSlot(J9ClassPointer var1, VoidPointer var2);

    protected void doClassLoader(J9ClassLoaderPointer slot, VoidPointer address) {
        try {
            this.doSlot(slot.classLoaderObject(), address);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    protected void doFinalizableObject(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doJNIWeakGlobalReference(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doJVMTIObjectTagSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doMonitorReference(J9ObjectMonitorPointer slot, VoidPointer address) {
        try {
            J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(slot.monitor());
            this.doSlot(J9ObjectPointer.cast(monitor.userData()), VoidPointer.cast(monitor.userDataEA()));
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Errror accessing object slot from J9ObjectMonitorPointer: " + slot.getHexAddress(), e, false);
        }
    }

    protected void doMonitorLookupCacheSlot(J9ObjectMonitorPointer slot, ObjectMonitorReferencePointer address) {
        try {
            J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(slot.monitor());
            this.doSlot(J9ObjectPointer.cast(monitor.userData()), VoidPointer.cast(monitor.userDataEA()));
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Errror accessing object slot from J9ObjectMonitorPointer: " + slot.getHexAddress(), e, false);
        }
    }

    protected void doPhantomReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doRememberedSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doSoftReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doStringCacheTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doStringTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doUnfinalizedObject(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doOwnableSynchronizerObject(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doVMClassSlot(J9ClassPointer slot, VoidPointer address) {
        this.doClassSlot(slot, address);
    }

    protected void doVMThreadJNISlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doNonCollectableObjectSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doMemoryAreaSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doVMThreadSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doWeakReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSlot(slot, address);
    }

    protected void doStackSlot(J9ObjectPointer slot, WalkState walkState, VoidPointer stackLocation) {
        this.doSlot(slot, stackLocation);
    }
}

