/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.structure.J9Consts;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassArrayClassSlotIterator
extends GCIterator {
    protected Iterator<J9ClassPointer> slotIterator;
    protected Iterator<VoidPointer> addressIterator;

    protected GCClassArrayClassSlotIterator(J9ClassPointer clazz) throws CorruptDataException {
        ArrayList<J9ClassPointer> slots = new ArrayList<J9ClassPointer>();
        ArrayList<VoidPointer> addresses = new ArrayList<VoidPointer>();
        J9ClassPointer slot = clazz.arrayClass();
        if (slot.notNull()) {
            slots.add(slot);
            addresses.add(VoidPointer.cast(clazz.arrayClassEA()));
        }
        if (clazz.romClass().modifiers().allBitsIn(J9Consts.J9_JAVA_CLASS_ARRAY)) {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
            slot = arrayClass.componentType();
            if (slot.notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(arrayClass.componentTypeEA()));
            }
            if ((slot = arrayClass.leafComponentType()).notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(arrayClass.leafComponentTypeEA()));
            }
        }
        this.slotIterator = slots.iterator();
        this.addressIterator = addresses.iterator();
    }

    public static GCClassArrayClassSlotIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassArrayClassSlotIterator(clazz);
    }

    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    public J9ClassPointer next() {
        this.addressIterator.next();
        return this.slotIterator.next();
    }

    public VoidPointer nextAddress() {
        this.slotIterator.next();
        return this.addressIterator.next();
    }
}

