/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm27.j9.gc.GCMemoryPoolIterator;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemorySubSpaceGenericPointer;
import java.util.NoSuchElementException;

class GCStandardMemoryPoolIterator
extends GCMemoryPoolIterator {
    protected MM_MemoryPoolPointer _currentMemoryPool = null;
    protected GCHeapRegionIterator _regionIterator = null;
    protected GCHeapRegionDescriptor _region = null;
    private IteratorState _state = IteratorState.mm_heapmp_iterator_next_region;

    public GCStandardMemoryPoolIterator() throws CorruptDataException {
        this._regionIterator = GCHeapRegionIterator.from();
        this.advancePool();
    }

    private void advancePool() {
        try {
            boolean poolFound = false;
            MM_MemoryPoolPointer memoryPool = null;
            while (!poolFound && this._regionIterator.hasNext()) {
                switch (this._state) {
                    case mm_heapmp_iterator_next_region: {
                        this._region = this._regionIterator.next();
                        MM_MemorySubSpaceGenericPointer subSpaceGeneric = MM_MemorySubSpaceGenericPointer.cast(this._region.getSubSpace());
                        if (!subSpaceGeneric.notNull() || !(memoryPool = subSpaceGeneric._memoryPool()).notNull()) break;
                        if (memoryPool._children().notNull()) {
                            memoryPool = memoryPool._children();
                        }
                        this._state = IteratorState.mm_heapmp_iterator_next_memory_pool;
                        poolFound = true;
                        break;
                    }
                    case mm_heapmp_iterator_next_memory_pool: {
                        memoryPool = this._currentMemoryPool._next();
                        if (memoryPool.isNull()) {
                            this._state = IteratorState.mm_heapmp_iterator_next_region;
                            break;
                        }
                        poolFound = true;
                    }
                }
            }
            this._currentMemoryPool = poolFound ? memoryPool : null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", e, false);
            this._currentMemoryPool = null;
        }
    }

    public GCMemoryPool next() {
        GCMemoryPool next = null;
        if (this.hasNext()) {
            try {
                next = GCMemoryPool.fromMemoryPoolPointerInRegion(this._region, this._currentMemoryPool);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", e, false);
            }
            this.advancePool();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public boolean hasNext() {
        return null != this._currentMemoryPool;
    }

    public String toString() {
        GCStandardMemoryPoolIterator tempIter = null;
        try {
            tempIter = new GCStandardMemoryPoolIterator();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next() + NEW_LINE);
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IteratorState {
        mm_heapmp_iterator_next_region,
        mm_heapmp_iterator_next_memory_pool,
        NULL;

    }
}

