/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.walkers;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm27.structure.J9PortLibrary;
import com.ibm.j9ddr.vm27.types.IDATA;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9MemTagIterator
implements Iterator<J9MemTagPointer> {
    private final long topAddress;
    private final byte[] headerEyecatcherBytes;
    private final long headerEyecatcher;
    private final long footerEyecatcher;
    private J9MemTagPointer current;
    private long currentSearchAddress;
    private boolean isFooterCorrupted;
    private boolean lookingForFreedCallSites;

    private J9MemTagIterator(long baseAddress, long topAddress, long headerEyecatcher, long footerEyecatcher) {
        this(baseAddress, topAddress, headerEyecatcher, footerEyecatcher, false);
    }

    private J9MemTagIterator(long baseAddress, long topAddress, long headerEyecatcher, long footerEyecatcher, boolean lookingForFreedCallSites) {
        this.topAddress = topAddress;
        this.headerEyecatcherBytes = this.longToByteString(headerEyecatcher);
        this.headerEyecatcher = headerEyecatcher;
        this.footerEyecatcher = footerEyecatcher;
        this.currentSearchAddress = baseAddress;
        this.isFooterCorrupted = false;
        this.lookingForFreedCallSites = lookingForFreedCallSites;
    }

    private byte[] longToByteString(long input) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(DataType.getProcess().getByteOrder());
        b.putLong(input);
        b.flip();
        byte[] toReturn = new byte[4];
        if (b.order() == ByteOrder.BIG_ENDIAN) {
            b.position(4);
        }
        b.get(toReturn, 0, 4);
        return toReturn;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        this.current = this.internalNext();
        return this.current != null;
    }

    public void moveCurrentSearchAddress(long jumpSize) {
        if (jumpSize > (long)UDATA.SIZEOF) {
            this.currentSearchAddress += jumpSize - (long)UDATA.SIZEOF;
        }
    }

    public boolean isFooterCorrupted() {
        return this.isFooterCorrupted;
    }

    private J9MemTagPointer internalNext() {
        long result;
        this.isFooterCorrupted = false;
        while (true) {
            if ((result = DataType.getProcess().findPattern(this.headerEyecatcherBytes, UDATA.SIZEOF, this.currentSearchAddress)) == -1L) {
                return null;
            }
            if (Addresses.greaterThan(result, this.topAddress)) {
                return null;
            }
            this.currentSearchAddress = result + (long)UDATA.SIZEOF;
            VoidPointer memoryBase = J9MemTagHelper.j9mem_get_memory_base(J9MemTagPointer.cast(result));
            try {
                IDATA corruption = J9MemTagHelper.j9mem_check_tags(VoidPointer.cast(memoryBase), this.headerEyecatcher, this.footerEyecatcher);
                if (corruption.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_NOT_A_TAG.longValue())) continue;
                if ((corruption.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED.longValue()) || corruption.allBitsIn(J9MemTagHelper.J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED.longValue())) && this.headerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && this.footerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                    this.isFooterCorrupted = true;
                    return J9MemTagPointer.cast(result);
                }
            }
            catch (J9MemTagHelper.J9MemTagCheckError e) {
                if (this.lookingForFreedCallSites) continue;
                EventManager.raiseCorruptDataEvent("Corrupt memory section found", e, false);
                continue;
            }
            break;
        }
        return J9MemTagPointer.cast(result);
    }

    @Override
    public J9MemTagPointer next() {
        if (this.hasNext()) {
            J9MemTagPointer toReturn = this.current;
            this.current = null;
            return toReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static J9MemTagIterator iterateHeaders(long baseAddress, long topAddress, long headerEyecatcher, long footerEyecatcher) {
        return new J9MemTagIterator(baseAddress, topAddress, headerEyecatcher, footerEyecatcher);
    }

    public static J9MemTagIterator iterateHeaders(long baseAddress, long topAddress, long headerEyecatcher, long footerEyecatcher, boolean lookingForFreedCallSites) {
        return new J9MemTagIterator(baseAddress, topAddress, headerEyecatcher, footerEyecatcher, lookingForFreedCallSites);
    }

    public static J9MemTagIterator iterateAllocatedHeaders(long baseAddress, long topAddress) {
        return J9MemTagIterator.iterateHeaders(baseAddress, topAddress, J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_HEADER, J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_FOOTER);
    }

    public static J9MemTagIterator iterateAllocatedHeaders() {
        return J9MemTagIterator.iterateAllocatedHeaders(0L, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders() {
        return J9MemTagIterator.iterateFreedHeaders(0L, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders(long baseAddress) {
        return J9MemTagIterator.iterateFreedHeaders(baseAddress, UDATA.MASK);
    }

    public static J9MemTagIterator iterateFreedHeaders(long baseAddress, long topAddress) {
        return J9MemTagIterator.iterateHeaders(baseAddress, topAddress, J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER, J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER, true);
    }
}

