/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.Pointer;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

public class FloatPointer
extends Pointer {
    public static final int SIZEOF = 4;
    public static final FloatPointer NULL = new FloatPointer(0L);

    protected FloatPointer(long address) {
        super(address);
    }

    public static FloatPointer cast(AbstractPointer pointer) {
        return FloatPointer.cast(pointer.getAddress());
    }

    public static FloatPointer cast(UDATA udata) {
        return FloatPointer.cast(udata.longValue());
    }

    public static FloatPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new FloatPointer(address);
    }

    public FloatPointer at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException("Use floatAt(long index)");
    }

    public FloatPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public long longAt(long index) throws CorruptDataException {
        return (long)this.floatAt(index);
    }

    public double doubleAt(long index) throws CorruptDataException {
        return this.floatAt(index);
    }

    public float floatAt(long index) throws CorruptDataException {
        return this.getFloatAtOffset(index * 4L);
    }

    public FloatPointer add(long count) {
        return new FloatPointer(this.address + 4L * count);
    }

    public FloatPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public FloatPointer addOffset(long offset) {
        return new FloatPointer(this.address + offset);
    }

    public FloatPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public FloatPointer sub(long count) {
        return new FloatPointer(this.address - 4L * count);
    }

    public FloatPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public FloatPointer subOffset(long offset) {
        return new FloatPointer(this.address - offset);
    }

    public FloatPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public FloatPointer untag() {
        return this.untag(3L);
    }

    public FloatPointer untag(long mask) {
        return new FloatPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    protected long sizeOfBaseType() {
        return 4L;
    }
}

