/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.StoragePointer;
import com.ibm.j9ddr.vm27.structure.ByteBuffer;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=ByteBuffer.class)
public class ByteBufferPointer
extends StoragePointer {
    public static final ByteBufferPointer NULL = new ByteBufferPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ByteBufferPointer(long address) {
        super(address);
    }

    public static ByteBufferPointer cast(AbstractPointer structure) {
        return ByteBufferPointer.cast(structure.getAddress());
    }

    public static ByteBufferPointer cast(UDATA udata) {
        return ByteBufferPointer.cast(udata.longValue());
    }

    public static ByteBufferPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ByteBufferPointer(address);
    }

    public ByteBufferPointer add(long count) {
        return ByteBufferPointer.cast(this.address + ByteBuffer.SIZEOF * count);
    }

    public ByteBufferPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ByteBufferPointer addOffset(long offset) {
        return ByteBufferPointer.cast(this.address + offset);
    }

    public ByteBufferPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public ByteBufferPointer sub(long count) {
        return ByteBufferPointer.cast(this.address - ByteBuffer.SIZEOF * count);
    }

    public ByteBufferPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ByteBufferPointer subOffset(long offset) {
        return ByteBufferPointer.cast(this.address - offset);
    }

    public ByteBufferPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ByteBufferPointer untag(long mask) {
        return ByteBufferPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ByteBufferPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return ByteBuffer.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="__capacityOffset_", declaredType="UDATA")
    public UDATA _capacity() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(ByteBuffer.__capacityOffset_));
    }

    public UDATAPointer _capacityEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)ByteBuffer.__capacityOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="__dataOffset_", declaredType="U8*")
    public U8Pointer _data() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(ByteBuffer.__dataOffset_));
    }

    public PointerPointer _dataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ByteBuffer.__dataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="__limitOffset_", declaredType="UDATA")
    public UDATA _limit() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(ByteBuffer.__limitOffset_));
    }

    public UDATAPointer _limitEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)ByteBuffer.__limitOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="__positionOffset_", declaredType="int")
    public I32 _position() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteBuffer.__positionOffset_));
    }

    public I32Pointer _positionEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)ByteBuffer.__positionOffset_);
    }
}

