/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.structure.CharArrayWrapper;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=CharArrayWrapper.class)
public class CharArrayWrapperPointer
extends StructurePointer {
    public static final CharArrayWrapperPointer NULL = new CharArrayWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected CharArrayWrapperPointer(long address) {
        super(address);
    }

    public static CharArrayWrapperPointer cast(AbstractPointer structure) {
        return CharArrayWrapperPointer.cast(structure.getAddress());
    }

    public static CharArrayWrapperPointer cast(UDATA udata) {
        return CharArrayWrapperPointer.cast(udata.longValue());
    }

    public static CharArrayWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CharArrayWrapperPointer(address);
    }

    public CharArrayWrapperPointer add(long count) {
        return CharArrayWrapperPointer.cast(this.address + CharArrayWrapper.SIZEOF * count);
    }

    public CharArrayWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public CharArrayWrapperPointer addOffset(long offset) {
        return CharArrayWrapperPointer.cast(this.address + offset);
    }

    public CharArrayWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public CharArrayWrapperPointer sub(long count) {
        return CharArrayWrapperPointer.cast(this.address - CharArrayWrapper.SIZEOF * count);
    }

    public CharArrayWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public CharArrayWrapperPointer subOffset(long offset) {
        return CharArrayWrapperPointer.cast(this.address - offset);
    }

    public CharArrayWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public CharArrayWrapperPointer untag(long mask) {
        return CharArrayWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public CharArrayWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return CharArrayWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_objectSizeOffset_", declaredType="U32")
    public U32 objectSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(CharArrayWrapper._objectSizeOffset_));
    }

    public U32Pointer objectSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)CharArrayWrapper._objectSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romStringOffsetOffset_", declaredType="J9SRP")
    public VoidPointer romStringOffset() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long nextAddress = this.getIntAtOffset(CharArrayWrapper._romStringOffsetOffset_);
        if (nextAddress == 0L) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.address + ((long)CharArrayWrapper._romStringOffsetOffset_ + nextAddress));
    }

    public SelfRelativePointer romStringOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return SelfRelativePointer.cast(this.address + (long)CharArrayWrapper._romStringOffsetOffset_);
    }
}

