/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.structure.CompiledMethodWrapper;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=CompiledMethodWrapper.class)
public class CompiledMethodWrapperPointer
extends StructurePointer {
    public static final CompiledMethodWrapperPointer NULL = new CompiledMethodWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected CompiledMethodWrapperPointer(long address) {
        super(address);
    }

    public static CompiledMethodWrapperPointer cast(AbstractPointer structure) {
        return CompiledMethodWrapperPointer.cast(structure.getAddress());
    }

    public static CompiledMethodWrapperPointer cast(UDATA udata) {
        return CompiledMethodWrapperPointer.cast(udata.longValue());
    }

    public static CompiledMethodWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CompiledMethodWrapperPointer(address);
    }

    public CompiledMethodWrapperPointer add(long count) {
        return CompiledMethodWrapperPointer.cast(this.address + CompiledMethodWrapper.SIZEOF * count);
    }

    public CompiledMethodWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public CompiledMethodWrapperPointer addOffset(long offset) {
        return CompiledMethodWrapperPointer.cast(this.address + offset);
    }

    public CompiledMethodWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public CompiledMethodWrapperPointer sub(long count) {
        return CompiledMethodWrapperPointer.cast(this.address - CompiledMethodWrapper.SIZEOF * count);
    }

    public CompiledMethodWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public CompiledMethodWrapperPointer subOffset(long offset) {
        return CompiledMethodWrapperPointer.cast(this.address - offset);
    }

    public CompiledMethodWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public CompiledMethodWrapperPointer untag(long mask) {
        return CompiledMethodWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public CompiledMethodWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return CompiledMethodWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_codeLengthOffset_", declaredType="U32")
    public U32 codeLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(CompiledMethodWrapper._codeLengthOffset_));
    }

    public U32Pointer codeLengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)CompiledMethodWrapper._codeLengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
    public U32 dataLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(CompiledMethodWrapper._dataLengthOffset_));
    }

    public U32Pointer dataLengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)CompiledMethodWrapper._dataLengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romMethodOffsetOffset_", declaredType="I32")
    public I32 romMethodOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(CompiledMethodWrapper._romMethodOffsetOffset_));
    }

    public I32Pointer romMethodOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)CompiledMethodWrapper._romMethodOffsetOffset_);
    }
}

