/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U16Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.structure.J9CfrMember;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U16;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=J9CfrMember.class)
public class J9CfrMemberPointer
extends StructurePointer {
    public static final J9CfrMemberPointer NULL = new J9CfrMemberPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9CfrMemberPointer(long address) {
        super(address);
    }

    public static J9CfrMemberPointer cast(AbstractPointer structure) {
        return J9CfrMemberPointer.cast(structure.getAddress());
    }

    public static J9CfrMemberPointer cast(UDATA udata) {
        return J9CfrMemberPointer.cast(udata.longValue());
    }

    public static J9CfrMemberPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9CfrMemberPointer(address);
    }

    public J9CfrMemberPointer add(long count) {
        return J9CfrMemberPointer.cast(this.address + J9CfrMember.SIZEOF * count);
    }

    public J9CfrMemberPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9CfrMemberPointer addOffset(long offset) {
        return J9CfrMemberPointer.cast(this.address + offset);
    }

    public J9CfrMemberPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9CfrMemberPointer sub(long count) {
        return J9CfrMemberPointer.cast(this.address - J9CfrMember.SIZEOF * count);
    }

    public J9CfrMemberPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9CfrMemberPointer subOffset(long offset) {
        return J9CfrMemberPointer.cast(this.address - offset);
    }

    public J9CfrMemberPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9CfrMemberPointer untag(long mask) {
        return J9CfrMemberPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9CfrMemberPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9CfrMember.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_accessFlagsOffset_", declaredType="U16")
    public U16 accessFlags() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9CfrMember._accessFlagsOffset_));
    }

    public U16Pointer accessFlagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9CfrMember._accessFlagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_attributesOffset_", declaredType="struct J9CfrAttribute**")
    public PointerPointer attributes() throws CorruptDataException {
        return PointerPointer.cast(this.getPointerAtOffset(J9CfrMember._attributesOffset_));
    }

    public PointerPointer attributesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9CfrMember._attributesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_attributesCountOffset_", declaredType="U16")
    public U16 attributesCount() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9CfrMember._attributesCountOffset_));
    }

    public U16Pointer attributesCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9CfrMember._attributesCountOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_descriptorIndexOffset_", declaredType="U16")
    public U16 descriptorIndex() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9CfrMember._descriptorIndexOffset_));
    }

    public U16Pointer descriptorIndexEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9CfrMember._descriptorIndexOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nameIndexOffset_", declaredType="U16")
    public U16 nameIndex() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9CfrMember._nameIndexOffset_));
    }

    public U16Pointer nameIndexEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9CfrMember._nameIndexOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romAddressOffset_", declaredType="UDATA")
    public UDATA romAddress() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9CfrMember._romAddressOffset_));
    }

    public UDATAPointer romAddressEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9CfrMember._romAddressOffset_);
    }
}

