/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U64Pointer;
import com.ibm.j9ddr.vm27.structure.J9UnsafeMemoryBlock;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U64;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=J9UnsafeMemoryBlock.class)
public class J9UnsafeMemoryBlockPointer
extends StructurePointer {
    public static final J9UnsafeMemoryBlockPointer NULL = new J9UnsafeMemoryBlockPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9UnsafeMemoryBlockPointer(long address) {
        super(address);
    }

    public static J9UnsafeMemoryBlockPointer cast(AbstractPointer structure) {
        return J9UnsafeMemoryBlockPointer.cast(structure.getAddress());
    }

    public static J9UnsafeMemoryBlockPointer cast(UDATA udata) {
        return J9UnsafeMemoryBlockPointer.cast(udata.longValue());
    }

    public static J9UnsafeMemoryBlockPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9UnsafeMemoryBlockPointer(address);
    }

    public J9UnsafeMemoryBlockPointer add(long count) {
        return J9UnsafeMemoryBlockPointer.cast(this.address + J9UnsafeMemoryBlock.SIZEOF * count);
    }

    public J9UnsafeMemoryBlockPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9UnsafeMemoryBlockPointer addOffset(long offset) {
        return J9UnsafeMemoryBlockPointer.cast(this.address + offset);
    }

    public J9UnsafeMemoryBlockPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9UnsafeMemoryBlockPointer sub(long count) {
        return J9UnsafeMemoryBlockPointer.cast(this.address - J9UnsafeMemoryBlock.SIZEOF * count);
    }

    public J9UnsafeMemoryBlockPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9UnsafeMemoryBlockPointer subOffset(long offset) {
        return J9UnsafeMemoryBlockPointer.cast(this.address - offset);
    }

    public J9UnsafeMemoryBlockPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9UnsafeMemoryBlockPointer untag(long mask) {
        return J9UnsafeMemoryBlockPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9UnsafeMemoryBlockPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9UnsafeMemoryBlock.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataOffset_", declaredType="U64")
    public U64 data() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9UnsafeMemoryBlock._dataOffset_));
    }

    public U64Pointer dataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)J9UnsafeMemoryBlock._dataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_linkNextOffset_", declaredType="struct J9UnsafeMemoryBlock*")
    public J9UnsafeMemoryBlockPointer linkNext() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9UnsafeMemoryBlock._linkNextOffset_);
        return J9UnsafeMemoryBlockPointer.cast(pointer);
    }

    public PointerPointer linkNextEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9UnsafeMemoryBlock._linkNextOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_linkPreviousOffset_", declaredType="struct J9UnsafeMemoryBlock*")
    public J9UnsafeMemoryBlockPointer linkPrevious() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9UnsafeMemoryBlock._linkPreviousOffset_);
        return J9UnsafeMemoryBlockPointer.cast(pointer);
    }

    public PointerPointer linkPreviousEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9UnsafeMemoryBlock._linkPreviousOffset_);
    }
}

