/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemCategoryPointer;
import com.ibm.j9ddr.vm27.structure.J9VirtHandle;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=J9VirtHandle.class)
public class J9VirtHandlePointer
extends StructurePointer {
    public static final J9VirtHandlePointer NULL = new J9VirtHandlePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9VirtHandlePointer(long address) {
        super(address);
    }

    public static J9VirtHandlePointer cast(AbstractPointer structure) {
        return J9VirtHandlePointer.cast(structure.getAddress());
    }

    public static J9VirtHandlePointer cast(UDATA udata) {
        return J9VirtHandlePointer.cast(udata.longValue());
    }

    public static J9VirtHandlePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9VirtHandlePointer(address);
    }

    public J9VirtHandlePointer add(long count) {
        return J9VirtHandlePointer.cast(this.address + J9VirtHandle.SIZEOF * count);
    }

    public J9VirtHandlePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9VirtHandlePointer addOffset(long offset) {
        return J9VirtHandlePointer.cast(this.address + offset);
    }

    public J9VirtHandlePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9VirtHandlePointer sub(long count) {
        return J9VirtHandlePointer.cast(this.address - J9VirtHandle.SIZEOF * count);
    }

    public J9VirtHandlePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9VirtHandlePointer subOffset(long offset) {
        return J9VirtHandlePointer.cast(this.address - offset);
    }

    public J9VirtHandlePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9VirtHandlePointer untag(long mask) {
        return J9VirtHandlePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9VirtHandlePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9VirtHandle.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_allocHdrOffset_", declaredType="void*")
    public VoidPointer allocHdr() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9VirtHandle._allocHdrOffset_));
    }

    public PointerPointer allocHdrEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9VirtHandle._allocHdrOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_allocPtrOffset_", declaredType="void*")
    public VoidPointer allocPtr() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9VirtHandle._allocPtrOffset_));
    }

    public PointerPointer allocPtrEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9VirtHandle._allocPtrOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_allocSzOffset_", declaredType="UDATA")
    public UDATA allocSz() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9VirtHandle._allocSzOffset_));
    }

    public UDATAPointer allocSzEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9VirtHandle._allocSzOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_categoryOffset_", declaredType="J9MemCategory*")
    public J9MemCategoryPointer category() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9VirtHandle._categoryOffset_);
        return J9MemCategoryPointer.cast(pointer);
    }

    public PointerPointer categoryEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9VirtHandle._categoryOffset_);
    }
}

