/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.structure.UtDataHeader;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=UtDataHeader.class)
public class UtDataHeaderPointer
extends StructurePointer {
    public static final UtDataHeaderPointer NULL = new UtDataHeaderPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected UtDataHeaderPointer(long address) {
        super(address);
    }

    public static UtDataHeaderPointer cast(AbstractPointer structure) {
        return UtDataHeaderPointer.cast(structure.getAddress());
    }

    public static UtDataHeaderPointer cast(UDATA udata) {
        return UtDataHeaderPointer.cast(udata.longValue());
    }

    public static UtDataHeaderPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UtDataHeaderPointer(address);
    }

    public UtDataHeaderPointer add(long count) {
        return UtDataHeaderPointer.cast(this.address + UtDataHeader.SIZEOF * count);
    }

    public UtDataHeaderPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public UtDataHeaderPointer addOffset(long offset) {
        return UtDataHeaderPointer.cast(this.address + offset);
    }

    public UtDataHeaderPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public UtDataHeaderPointer sub(long count) {
        return UtDataHeaderPointer.cast(this.address - UtDataHeader.SIZEOF * count);
    }

    public UtDataHeaderPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public UtDataHeaderPointer subOffset(long offset) {
        return UtDataHeaderPointer.cast(this.address - offset);
    }

    public UtDataHeaderPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public UtDataHeaderPointer untag(long mask) {
        return UtDataHeaderPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public UtDataHeaderPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return UtDataHeader.SIZEOF;
    }

    public U8Pointer eyecatcherEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)UtDataHeader._eyecatcherOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_lengthOffset_", declaredType="I32")
    public I32 length() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtDataHeader._lengthOffset_));
    }

    public I32Pointer lengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtDataHeader._lengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_modificationOffset_", declaredType="I32")
    public I32 modification() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtDataHeader._modificationOffset_));
    }

    public I32Pointer modificationEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtDataHeader._modificationOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="I32")
    public I32 version() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtDataHeader._versionOffset_));
    }

    public I32Pointer versionEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtDataHeader._versionOffset_);
    }
}

