/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.EnumPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.UtDataHeaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.UtProcInfoPointer;
import com.ibm.j9ddr.vm27.structure.UtArchitecture;
import com.ibm.j9ddr.vm27.structure.UtProcessorInfo;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=UtProcessorInfo.class)
public class UtProcessorInfoPointer
extends StructurePointer {
    public static final UtProcessorInfoPointer NULL = new UtProcessorInfoPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected UtProcessorInfoPointer(long address) {
        super(address);
    }

    public static UtProcessorInfoPointer cast(AbstractPointer structure) {
        return UtProcessorInfoPointer.cast(structure.getAddress());
    }

    public static UtProcessorInfoPointer cast(UDATA udata) {
        return UtProcessorInfoPointer.cast(udata.longValue());
    }

    public static UtProcessorInfoPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UtProcessorInfoPointer(address);
    }

    public UtProcessorInfoPointer add(long count) {
        return UtProcessorInfoPointer.cast(this.address + UtProcessorInfo.SIZEOF * count);
    }

    public UtProcessorInfoPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public UtProcessorInfoPointer addOffset(long offset) {
        return UtProcessorInfoPointer.cast(this.address + offset);
    }

    public UtProcessorInfoPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public UtProcessorInfoPointer sub(long count) {
        return UtProcessorInfoPointer.cast(this.address - UtProcessorInfo.SIZEOF * count);
    }

    public UtProcessorInfoPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public UtProcessorInfoPointer subOffset(long offset) {
        return UtProcessorInfoPointer.cast(this.address - offset);
    }

    public UtProcessorInfoPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public UtProcessorInfoPointer untag(long mask) {
        return UtProcessorInfoPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public UtProcessorInfoPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return UtProcessorInfo.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_architectureOffset_", declaredType="UtArchitecture")
    public long architecture() throws CorruptDataException {
        if (UtArchitecture.SIZEOF == 1L) {
            return this.getByteAtOffset(UtProcessorInfo._architectureOffset_);
        }
        if (UtArchitecture.SIZEOF == 2L) {
            return this.getShortAtOffset(UtProcessorInfo._architectureOffset_);
        }
        if (UtArchitecture.SIZEOF == 4L) {
            return this.getIntAtOffset(UtProcessorInfo._architectureOffset_);
        }
        if (UtArchitecture.SIZEOF == 8L) {
            return this.getLongAtOffset(UtProcessorInfo._architectureOffset_);
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    public EnumPointer architectureEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return EnumPointer.cast(this.address + (long)UtProcessorInfo._architectureOffset_, UtArchitecture.class);
    }

    @GeneratedFieldAccessor(offsetFieldName="_cpuCountVariesOffset_", declaredType="I32")
    public I32 cpuCountVaries() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtProcessorInfo._cpuCountVariesOffset_));
    }

    public I32Pointer cpuCountVariesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtProcessorInfo._cpuCountVariesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="UtDataHeader")
    public UtDataHeaderPointer header() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UtDataHeaderPointer.cast(this.address + (long)UtProcessorInfo._headerOffset_);
    }

    public PointerPointer headerEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UtProcessorInfo._headerOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_isBigEndianOffset_", declaredType="I32")
    public I32 isBigEndian() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtProcessorInfo._isBigEndianOffset_));
    }

    public I32Pointer isBigEndianEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtProcessorInfo._isBigEndianOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_onlineProcessorsOffset_", declaredType="U32")
    public U32 onlineProcessors() throws CorruptDataException {
        return new U32(this.getIntAtOffset(UtProcessorInfo._onlineProcessorsOffset_));
    }

    public U32Pointer onlineProcessorsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)UtProcessorInfo._onlineProcessorsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_pagesizeOffset_", declaredType="U32")
    public U32 pagesize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(UtProcessorInfo._pagesizeOffset_));
    }

    public U32Pointer pagesizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)UtProcessorInfo._pagesizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_procInfoOffset_", declaredType="UtProcInfo")
    public UtProcInfoPointer procInfo() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UtProcInfoPointer.cast(this.address + (long)UtProcessorInfo._procInfoOffset_);
    }

    public PointerPointer procInfoEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UtProcessorInfo._procInfoOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_wordsizeOffset_", declaredType="U32")
    public U32 wordsize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(UtProcessorInfo._wordsizeOffset_));
    }

    public U32Pointer wordsizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)UtProcessorInfo._wordsizeOffset_);
    }
}

