/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;

public class DumpRomClassLinearCommand
extends Command {
    public DumpRomClassLinearCommand() {
        this.addCommand("dumpromclasslinear", "<addr>[,n]", "cfdump the specified J9ROMClass using Linear ROM Class Dumper");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            throw new DDRInteractiveCommandException("This debug extension needs an address argument !dumpromclasslinear <addr>[,n]");
        }
        String[] arguments = args[0].split(",");
        long addr = Long.decode(arguments[0]);
        long nestingThreshold = arguments.length > 1 ? Long.decode(arguments[1]) : 1L;
        J9ROMClassPointer clazz = J9ROMClassPointer.cast(addr);
        try {
            out.println(String.format("ROM Class '%s' at %s", J9UTF8Helper.stringValue(clazz.className()), clazz.getHexAddress()));
            RomClassWalker classWalker = new RomClassWalker(clazz, context);
            new LinearDumper().gatherLayoutInfo(out, classWalker, nestingThreshold);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

