/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;

public class HashCodeCommand
extends Command {
    public HashCodeCommand() {
        this.addCommand("hashcode", "<address>", "prints out the Object.hashcode() for an object");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            throw new DDRInteractiveCommandException("This debug extension needs a single address argument: !hashcode <object addr>");
        }
        long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        J9ObjectPointer objectPointer = J9ObjectPointer.cast(address);
        try {
            J9ClassPointer clazz = J9ObjectHelper.clazz(objectPointer);
            if (!J9ClassHelper.hasValidEyeCatcher(clazz)) {
                throw new DDRInteractiveCommandException("object class is not valid (eyecatcher is not 0x99669966)");
            }
        }
        catch (CorruptDataException cde) {
            throw new DDRInteractiveCommandException("memory fault de-referencing address argument", cde);
        }
        try {
            out.println(ObjectModel.getObjectHashCode(objectPointer).getHexValue());
        }
        catch (CorruptDataException cde) {
            throw new DDRInteractiveCommandException("error calculating hashcode", cde);
        }
    }
}

