/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.MonitorTable;
import com.ibm.j9ddr.vm27.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm27.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm27.j9.ObjectMonitor;
import com.ibm.j9ddr.vm27.j9.Pool;
import com.ibm.j9ddr.vm27.j9.SlotIterator;
import com.ibm.j9ddr.vm27.j9.SystemMonitor;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.j9.walkers.HeapWalker;
import com.ibm.j9ddr.vm27.j9.walkers.MonitorIterator;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9VMThreadHelper;
import com.ibm.j9ddr.vm27.structure.J9ThreadAbstractMonitor;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.monitors.DeadlockDetector;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorsCommand
extends Command {
    public MonitorsCommand() {
        this.addCommand("monitors", "<command> | help", "Monitor related commands");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length < 1) {
                out.println("No subcommand specified. \"!monitors help\" for usage");
                return;
            }
            String monitorCommand = args[0];
            if (monitorCommand.equalsIgnoreCase("table")) {
                this.tableCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("tables")) {
                this.tablesCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("system")) {
                this.systemCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("object")) {
                this.objectCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("objects")) {
                this.objectsCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("thread")) {
                this.threadCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("j9thread")) {
                this.j9threadCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("j9vmthread")) {
                this.j9vmthreadCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("deadlock")) {
                this.deadlockCommand(args, out);
            } else if (monitorCommand.equalsIgnoreCase("help")) {
                this.helpCommand(args, out);
            } else {
                this.allCommand(args, out);
            }
        }
        catch (Exception e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void deadlockCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        DeadlockDetector.findDeadlocks(out);
    }

    private void threadCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length < 2) {
            out.println("This command takes one address argument: \"!monitors thread <address>\"");
            return;
        }
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            VoidPointer ptr = VoidPointer.cast(address);
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            J9ThreadLibraryPointer lib = mainThread.osThread().library();
            J9PoolPointer pool = lib.thread_pool();
            Pool<J9ThreadPointer> threadPool = Pool.fromJ9Pool(pool, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> poolIterator = threadPool.iterator();
            J9ThreadPointer osThreadPtr = null;
            while (poolIterator.hasNext()) {
                osThreadPtr = (J9ThreadPointer)poolIterator.next();
                J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(osThreadPtr);
                J9ObjectPointer jlThread = null;
                if (vmThread.notNull()) {
                    jlThread = vmThread.threadObject();
                    if (null != jlThread && jlThread.equals(ptr)) {
                        out.println("Found java/lang/Thread @ " + ptr.getHexAddress());
                        this.printMonitorsForJ9VMThread(out, vm, vmThread);
                        return;
                    }
                    if (vmThread.equals(ptr)) {
                        out.println("Found j9vmthread @ " + ptr.getHexAddress());
                        this.printMonitorsForJ9VMThread(out, vm, vmThread);
                        return;
                    }
                }
                if (!osThreadPtr.equals(ptr)) continue;
                out.println("Found j9thread @ " + ptr.getHexAddress());
                if (vmThread.notNull()) {
                    this.printMonitorsForJ9VMThread(out, vm, vmThread);
                }
                this.printMonitorsForJ9Thread(out, vm, osThreadPtr);
                return;
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void j9vmthreadCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length < 2) {
            out.println("This command takes one address argument: \"!monitors j9vmthread <address>\"");
            return;
        }
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            VoidPointer ptr = VoidPointer.cast(address);
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer thread = null;
            GCVMThreadListIterator threadIterator = GCVMThreadListIterator.from();
            while (threadIterator.hasNext()) {
                if (!ptr.equals(threadIterator.next())) continue;
                thread = J9VMThreadPointer.cast(ptr);
            }
            if (null == thread) {
                throw new DDRInteractiveCommandException(String.format("Could not find any j9vmthread at address %s\n", ptr.getHexAddress()));
            }
            out.println(String.format("!j9vmthread 0x%08x\t!j9thread 0x%08x\t// %s", thread.getAddress(), thread.osThread().getAddress(), J9VMThreadHelper.getName(thread)));
            this.printMonitorsForJ9VMThread(out, vm, thread);
            this.printMonitorsForJ9Thread(out, vm, thread.osThread());
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printMonitorsForJ9VMThread(PrintStream out, J9JavaVMPointer vm, J9VMThreadPointer thread) throws CorruptDataException {
        FilterOptions defaultFilter = FilterOptions.defaultOption();
        MonitorIterator iterator = new MonitorIterator(vm);
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (!(current instanceof ObjectMonitor)) continue;
            ObjectMonitor objMon = (ObjectMonitor)current;
            if (thread.equals(objMon.getOwner())) {
                out.print("Owns Object Monitor:\n\t");
                this.writeObjectMonitor(defaultFilter, objMon, out);
            }
            for (J9VMThreadPointer threadPtr : objMon.getBlockedThreads()) {
                if (!threadPtr.equals(thread)) continue;
                out.print(String.format("Blocking on (Enter Waiter):\n\t", new Object[0]));
                this.writeObjectMonitor(defaultFilter, objMon, out);
            }
            for (J9VMThreadPointer threadPtr : objMon.getWaitingThreads()) {
                if (!threadPtr.equals(thread)) continue;
                out.print(String.format("Waiting on (Notify Waiter):\n\t", new Object[0]));
                this.writeObjectMonitor(defaultFilter, objMon, out);
            }
        }
    }

    private void j9threadCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length < 2) {
            out.println("This command takes one address argument: \"!monitors j9thread <address>\"");
            return;
        }
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            VoidPointer ptr = VoidPointer.cast(address);
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.isNull() || mainThread.osThread().isNull() || mainThread.osThread().library().isNull()) {
                throw new CorruptDataException("Cannot locate thread library");
            }
            J9ThreadLibraryPointer lib = mainThread.osThread().library();
            J9PoolPointer pool = lib.thread_pool();
            Pool<J9ThreadPointer> threadPool = Pool.fromJ9Pool(pool, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> poolIterator = threadPool.iterator();
            J9ThreadPointer osThreadPtr = null;
            while (poolIterator.hasNext()) {
                if (!ptr.equals(poolIterator.next())) continue;
                osThreadPtr = J9ThreadPointer.cast(ptr);
            }
            if (null == osThreadPtr) {
                throw new DDRInteractiveCommandException(String.format("Could not find any j9thread at address %s\n", ptr.getHexAddress()));
            }
            J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(osThreadPtr);
            out.println(String.format("%s\t%s\t// %s", osThreadPtr.formatShortInteractive(), vmThread.notNull() ? vmThread.formatShortInteractive() : "<none>", vmThread.notNull() ? J9VMThreadHelper.getName(vmThread) : "[osthread]"));
            this.printMonitorsForJ9Thread(out, vm, osThreadPtr);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printMonitorsForJ9Thread(PrintStream out, J9JavaVMPointer vm, J9ThreadPointer osThreadPtr) throws CorruptDataException {
        FilterOptions defaultFilter = FilterOptions.defaultOption();
        MonitorIterator iterator = new MonitorIterator(vm);
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (!(current instanceof J9ThreadMonitorPointer)) continue;
            SystemMonitor monitor = SystemMonitor.fromJ9ThreadMonitor((J9ThreadMonitorPointer)current);
            List<J9ThreadPointer> threadList = null;
            J9ThreadPointer ownerPtr = monitor.getOwner();
            if (ownerPtr.notNull() && ownerPtr.equals(osThreadPtr)) {
                out.print("Owns System Monitor:\n\t");
                this.writeSystemMonitor(defaultFilter, monitor, out);
            }
            threadList = monitor.getBlockedThreads();
            for (J9ThreadPointer thread : threadList) {
                if (!osThreadPtr.equals(thread)) continue;
                out.print("Blocking on System Monitor (Enter Waiter):\n\t");
                this.writeSystemMonitor(defaultFilter, monitor, out);
            }
            threadList = monitor.getWaitingThreads();
            for (J9ThreadPointer thread : threadList) {
                if (!osThreadPtr.equals(thread)) continue;
                out.print("Waiting on System Monitor (Notify Waiter):\n\t");
                this.writeSystemMonitor(defaultFilter, monitor, out);
            }
        }
    }

    private void objectsCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        FilterOptions filter = FilterOptions.defaultOption();
        if (args.length > 1) {
            filter = FilterOptions.parseOption(args[1]);
        } else if (args.length == 1) {
            out.println("No filter specified, defaulting to 'active' monitors.");
        }
        this.objectsCommand(filter, out);
    }

    private void objectsCommand(FilterOptions filter, PrintStream out) throws DDRInteractiveCommandException {
        try {
            HashSet<ObjectMonitor> monitors = new HashSet<ObjectMonitor>();
            MonitorTableListIterator iterator = new MonitorTableListIterator();
            MonitorTable previousMonitorTable = null;
            StringBuilder builder = new StringBuilder();
            while (iterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitorPointer = iterator.next();
                MonitorTable currentMonitorTable = iterator.currentMonitorTable();
                ObjectMonitor found = this.tablePrintHelper(filter, builder, objectMonitorPointer);
                if (null != found) {
                    monitors.add(found);
                }
                if (!currentMonitorTable.equals(previousMonitorTable) && builder.length() > 0) {
                    if (null != previousMonitorTable) {
                        out.println();
                    }
                    out.println(iterator.currentMonitorTable().extraInfo());
                    previousMonitorTable = currentMonitorTable;
                }
                out.append(builder);
                builder.setLength(0);
            }
            for (ObjectMonitor objMon : HeapWalker.getFlatLockedMonitors()) {
                if (monitors.contains(objMon)) continue;
                this.writeObjectMonitorToBuffer(filter, objMon, builder);
            }
            if (builder.length() > 0) {
                out.append("<Flatlocked Monitors on Heap>\n");
                out.append(builder);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void systemCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        FilterOptions filter = FilterOptions.defaultOption();
        if (args.length > 1) {
            filter = FilterOptions.parseOption(args[1]);
        }
        if (args.length == 1) {
            out.println("No filter specified, defaulting to 'active' monitors.");
        }
        this.systemCommand(filter, out);
    }

    private void systemCommand(FilterOptions filter, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            MonitorIterator iterator = new MonitorIterator(vm);
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (!(current instanceof J9ThreadMonitorPointer)) continue;
                SystemMonitor monitor = SystemMonitor.fromJ9ThreadMonitor((J9ThreadMonitorPointer)current);
                this.writeSystemMonitor(filter, monitor, out);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private List<String> threadsListHelper(List<J9ThreadPointer> list) throws CorruptDataException {
        LinkedList<String> threadList = new LinkedList<String>();
        for (J9ThreadPointer thread : list) {
            J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(thread);
            if (vmThread.notNull()) {
                threadList.add(String.format("%s\t%s", vmThread.formatShortInteractive(), J9VMThreadHelper.getName(vmThread)));
            } else {
                threadList.add(String.format("%s\t%s", thread.formatShortInteractive(), "[osthread]"));
            }
            thread = thread.next();
        }
        return threadList;
    }

    private ObjectMonitor tablePrintHelper(FilterOptions filter, StringBuilder builder, J9ObjectMonitorPointer objectMonitorPointer) throws DDRInteractiveCommandException {
        try {
            J9ThreadMonitorPointer threadMonitorPointer = objectMonitorPointer.monitor();
            J9ThreadAbstractMonitorPointer lock = J9ThreadAbstractMonitorPointer.cast(threadMonitorPointer);
            if (lock.flags().allBitsIn(J9ThreadAbstractMonitor.J9THREAD_MONITOR_OBJECT) && !lock.userData().eq(0L)) {
                ObjectMonitor objMon;
                J9ObjectMonitorPointer j9objectMonitorPointer;
                J9ObjectPointer obj = J9ObjectPointer.cast(lock.userData());
                J9TenantNativeDataPointer tenant = J9TenantNativeDataPointer.NULL;
                if (TenantModel.isTenantEnabled() && (j9objectMonitorPointer = J9ObjectMonitorPointer.cast(lock.userData2())).notNull()) {
                    tenant = j9objectMonitorPointer.tenant();
                }
                if (null != (objMon = ObjectAccessBarrier.getMonitor(obj, tenant))) {
                    this.writeObjectMonitorToBuffer(filter, objMon, builder);
                    return objMon;
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        return null;
    }

    private void tableCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        FilterOptions filter = FilterOptions.defaultOption();
        if (args.length > 2) {
            filter = FilterOptions.parseOption(args[2]);
        } else if (args.length == 2) {
            out.println("No filter specified, defaulting to 'active' monitors.");
        } else if (args.length < 2) {
            out.println("This command takes one address argument: \"!monitors table <address>\"");
            return;
        }
        try {
            StringBuilder builder = new StringBuilder();
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            VoidPointer ptr = VoidPointer.cast(address);
            MonitorTableListIterator iterator = new MonitorTableListIterator();
            boolean foundTable = false;
            while (iterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitorPointer = iterator.next();
                MonitorTable currentMonitorTable = iterator.currentMonitorTable();
                if (!currentMonitorTable.getMonitorTableListEntryPointer().equals(ptr)) continue;
                this.tablePrintHelper(filter, builder, objectMonitorPointer);
                foundTable = true;
            }
            out.append(builder);
            if (!foundTable) {
                out.append(String.format("Could not find any J9MonitorTableListEntryPointer at address %s\n", ptr.getHexAddress()));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void tablesCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        try {
            MonitorTableListIterator iterator = new MonitorTableListIterator();
            MonitorTable previousMonitorTable = null;
            while (iterator.hasNext()) {
                MonitorTable currentMonitorTable = iterator.currentMonitorTable();
                if (!currentMonitorTable.equals(previousMonitorTable)) {
                    out.println(iterator.currentMonitorTable().extraInfo());
                }
                previousMonitorTable = currentMonitorTable;
                iterator.next();
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void objectCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        FilterOptions filter = FilterOptions.defaultOption();
        try {
            J9ObjectPointer object = null;
            if (args.length < 2) {
                out.println("This command takes one address \"!monitors object <J9Object address>\"");
                return;
            }
            long objectAddr = Long.decode(args[1]);
            object = J9ObjectPointer.cast(objectAddr);
            Set<ObjectMonitor> objectMonitorHashSet = ObjectMonitor.fromJ9Object(object);
            if (objectMonitorHashSet.isEmpty()) {
                out.printf("No corresponding monitors were found for %s\n", object.getHexAddress());
            } else {
                for (ObjectMonitor monitor : objectMonitorHashSet) {
                    this.writeObjectMonitor(filter, monitor, out);
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void writeObjectMonitor(FilterOptions filter, ObjectMonitor objectMonitor, PrintStream out) throws CorruptDataException {
        StringBuilder buf = new StringBuilder();
        this.writeObjectMonitorToBuffer(filter, objectMonitor, buf);
        out.print(buf.toString());
    }

    private void writeObjectMonitorToBuffer(FilterOptions filter, ObjectMonitor objMon, StringBuilder out) throws CorruptDataException {
        if (filter.shouldPrint(objMon)) {
            J9VMThreadPointer ownerThreadPointer;
            out.append(String.format("Object monitor for %s\t\n", objMon.getObject().formatShortInteractive()));
            if (objMon.isInflated()) {
                out.append("\tInflated\n");
            } else if (objMon.isContended()) {
                out.append("\tContended Flatlocked\n");
            } else if (objMon.getLockword().isNull()) {
                out.append("\tDeflated\n");
            } else {
                out.append("\tFlatlocked\n");
            }
            J9ObjectMonitorPointer j9ObjMonPtr = objMon.getJ9ObjectMonitorPointer();
            if (j9ObjMonPtr.notNull()) {
                out.append(String.format("\t%s   %s\n", j9ObjMonPtr.formatShortInteractive(), j9ObjMonPtr.monitor().formatShortInteractive()));
            }
            if ((ownerThreadPointer = objMon.getOwner()).notNull()) {
                out.append(String.format("\tOwner:\t%s\t%s\n", ownerThreadPointer.formatShortInteractive(), J9VMThreadHelper.getName(ownerThreadPointer)));
            }
            if (!objMon.getBlockedThreads().isEmpty()) {
                out.append(String.format("\t%s\t\n", "Blocking (Enter Waiter):"));
                for (J9VMThreadPointer threadPtr : objMon.getBlockedThreads()) {
                    out.append(String.format("\t\t%s\t%s\n", threadPtr.formatShortInteractive(), J9VMThreadHelper.getName(threadPtr)));
                }
            }
            if (!objMon.getWaitingThreads().isEmpty()) {
                out.append(String.format("\t%s\t\n", "Waiting (Notify Waiter):"));
                for (J9VMThreadPointer threadPtr : objMon.getWaitingThreads()) {
                    out.append(String.format("\t\t%s\t%s\n", threadPtr.formatShortInteractive(), J9VMThreadHelper.getName(threadPtr)));
                }
            }
            out.append(nl);
        }
    }

    private void writeSystemMonitor(FilterOptions filter, SystemMonitor monitor, PrintStream out) throws CorruptDataException {
        StringBuilder buf = new StringBuilder();
        this.writeSystemMonitorToBuffer(filter, monitor, buf);
        out.print(buf.toString());
    }

    private void writeSystemMonitorToBuffer(FilterOptions filter, SystemMonitor monitor, StringBuilder out) throws CorruptDataException {
        if (filter.shouldPrint(monitor)) {
            List<String> notifyThreads;
            List<String> blockedThreads;
            out.append(String.format("%s\t%s\n", monitor.getRawMonitor().formatShortInteractive(), monitor.getName()));
            J9ThreadPointer ownerPtr = monitor.getOwner();
            if (!ownerPtr.isNull()) {
                out.append(String.format("\tOwner:\t%s\n", ownerPtr.formatShortInteractive()));
            }
            if (!(blockedThreads = this.threadsListHelper(monitor.getBlockedThreads())).isEmpty()) {
                out.append("\tBlocking (Enter Waiter):\n");
                for (String aThread : blockedThreads) {
                    out.append(String.format("\t\t%s\n", aThread));
                }
            }
            if (!(notifyThreads = this.threadsListHelper(monitor.getWaitingThreads())).isEmpty()) {
                out.append("\tWaiting (Notify Waiter):\n");
                for (String aThread : notifyThreads) {
                    out.append(String.format("\t\t%s\n", aThread));
                }
            }
        }
    }

    private void allCommand(String[] args, PrintStream out) throws DDRInteractiveCommandException {
        FilterOptions filter = FilterOptions.defaultOption();
        if (args.length > 0) {
            filter = FilterOptions.parseOption(args[0]);
        }
        out.println("----------------");
        out.println("Object Monitors:");
        out.println("----------------");
        this.objectsCommand(filter, out);
        out.println("----------------");
        out.println("System Monitors:");
        out.println("----------------");
        this.systemCommand(filter, out);
    }

    private void helpCommand(String[] args, PrintStream out) {
        String blob = "!monitors table <address> [ owned | waiting | blocked | active | all ]\n\t- dump object monitor tables individually\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n\n!monitors tables\n\t- dump the object monitor table list\n\n!monitors system [ owned | waiting | blocked | active | all ]\n\t- dump system monitors, where:\n\t\towned\n\t\t\t- owned by a thread\n\t\twaiting\n\t\t\t- a thread is waiting on it\n\t\tblocked\n\t\t\t- a thread is blocked on it\n\t\tactive\n\t\t\t- any of owned, waiting, blocked\n\t\tall\n\t\t\t- any monitor\n\n!monitors object <address>\n\t- dump object monitors corresponding to the specified object (either flat locked or inflated)\n\n!monitors objects [ owned | waiting | blocked | active | all ]\n\t- dump all object monitors\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n\n!monitors j9thread <address>\n\t- dump all monitors that are active for a J9Thread\n\n!monitors j9vmthread <address>\n\t- dump all monitors that are active for a J9VMThread\n\n!monitors thread <address>\n\t- dump all monitors that are active for the specified J9Thread/J9VMThread/java.lang.Thread\n\n!monitors deadlock\n\t- search for deadlock conditions (supports J9Threads and J9VMThreads)\n\n!monitors [ owned | waiting | blocked | active | all ]\n\t- dump the system and flat locked or inflated object monitors\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n";
        out.print(blob);
    }

    static class FilterOptions {
        boolean all;
        boolean owner;
        boolean blocked;
        boolean waiting;

        private FilterOptions() {
        }

        public static FilterOptions defaultOption() {
            FilterOptions retVal = new FilterOptions();
            retVal.owner = true;
            retVal.blocked = true;
            retVal.waiting = true;
            return retVal;
        }

        public static FilterOptions parseOption(String str) throws DDRInteractiveCommandException {
            FilterOptions retVal = new FilterOptions();
            if (str.equalsIgnoreCase("all")) {
                retVal.all = true;
            } else if (str.equalsIgnoreCase("active")) {
                retVal.owner = true;
                retVal.blocked = true;
                retVal.waiting = true;
            } else if (str.equalsIgnoreCase("blocked")) {
                retVal.blocked = true;
            } else if (str.equalsIgnoreCase("waiting")) {
                retVal.waiting = true;
            } else if (str.equalsIgnoreCase("owned")) {
                retVal.owner = true;
            } else {
                String msg = "Unsupported subcommand \"" + str + "\", see \"!monitors help\" for usage.";
                throw new DDRInteractiveCommandException(msg);
            }
            return retVal;
        }

        public boolean shouldPrint(ObjectMonitor monitor) throws CorruptDataException {
            if (this.all) {
                return true;
            }
            if (monitor.getOwner().notNull() && this.owner) {
                return true;
            }
            if (!monitor.getBlockedThreads().isEmpty() && this.blocked) {
                return true;
            }
            return !monitor.getWaitingThreads().isEmpty() && this.waiting;
        }

        public boolean shouldPrint(SystemMonitor monitor) throws CorruptDataException {
            if (this.all) {
                return true;
            }
            if (monitor.getOwner().notNull() && this.owner) {
                return true;
            }
            if (!monitor.getBlockedThreads().isEmpty() && this.blocked) {
                return true;
            }
            return !monitor.getWaitingThreads().isEmpty() && this.waiting;
        }
    }
}

