/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.LiveSetWalker;
import com.ibm.j9ddr.vm27.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.MM_AllocationContextTarok;
import java.io.PrintStream;

public class ObjectRefsCommand
extends Command {
    public ObjectRefsCommand() {
        this.addCommand("objectrefs", "<address> [ heapWalk ] [ rootWalk ]", "Find and list all references to specified object");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (args.length < 1) {
                throw new DDRInteractiveCommandException("This debug extension takes an address argument \" !objectrefs <address> [ heapWalk ] [ rootWalk ]\"");
            }
            long addr = Long.decode(args[0]);
            J9ObjectPointer targetObject = J9ObjectPointer.cast(addr);
            boolean dumpHeap = false;
            boolean dumpRoots = false;
            if (1 == args.length) {
                dumpHeap = true;
                dumpRoots = true;
            } else {
                for (int i = 1; i < args.length; ++i) {
                    if ("heapWalk".equals(args[i])) {
                        dumpHeap = true;
                        continue;
                    }
                    if (!"rootWalk".equals(args[i])) continue;
                    dumpRoots = true;
                }
            }
            if (dumpHeap) {
                try {
                    this.dumpHeapReferences(vm, targetObject, out);
                }
                catch (CorruptDataException cde) {
                    cde.printStackTrace();
                }
            }
            if (dumpRoots) {
                try {
                    this.dumpLiveReferences(vm, targetObject, out);
                }
                catch (CorruptDataException cde) {
                    cde.printStackTrace();
                }
            }
        }
        catch (DDRInteractiveCommandException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace(out);
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void dumpHeapReferences(J9JavaVMPointer vm, J9ObjectPointer targetObject, PrintStream out) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            Table table = new Table("On Heap References");
            if (GCExtensions.isMultiTenantGC()) {
                table.row("object (!j9object)", "field (!j9object)", "!mm_heapregiondescriptorvlhgc", "AC (type)", "object's tenant");
            } else {
                table.row("object (!j9object)", "field (!j9object)", "!mm_heapregiondescriptorvlhgc", "AC (type)");
            }
            GCHeapRegionIterator regionIterator = GCHeapRegionIterator.from();
            while (regionIterator.hasNext()) {
                MM_AllocationContextMultiTenantPointer acmt;
                PointerPointer tenantContextJNIRef;
                GCHeapRegionDescriptor region = regionIterator.next();
                if (!region.containsObjects()) continue;
                MM_HeapRegionDescriptorVLHGCPointer vlhgcRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(region.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer currentAllocationContextTarok = vlhgcRegion._allocateData()._owningContext();
                String currentTenantID = "null";
                J9ObjectPointer currentTenant = J9ObjectPointer.NULL;
                if (GCExtensions.isMultiTenantGC() && MM_AllocationContextTarok.AllocationContextType.MULTI_TENANT == currentAllocationContextTarok._allocationContextType() && !(tenantContextJNIRef = (acmt = MM_AllocationContextMultiTenantPointer.cast(currentAllocationContextTarok))._tenantContext()).isNull() && !(currentTenant = J9ObjectPointer.cast(tenantContextJNIRef.at(0L))).isNull()) {
                    currentTenantID = TenantContextHelper.getDefault().id(currentTenant);
                }
                GCObjectHeapIterator heapObjectIterator = region.objectIterator(true, false);
                while (heapObjectIterator.hasNext()) {
                    J9ObjectPointer currentObject = heapObjectIterator.next();
                    GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(currentObject, false);
                    while (fieldIterator.hasNext()) {
                        J9ObjectPointer currentTargetObject = fieldIterator.next();
                        if (!currentTargetObject.eq(targetObject)) continue;
                        J9ClassPointer objectClass = J9ObjectHelper.clazz(currentObject);
                        String objectClassString = J9ClassHelper.getJavaName(objectClass);
                        if (GCExtensions.isMultiTenantGC()) {
                            table.row(currentObject.getHexAddress() + " //" + objectClassString, currentTargetObject.getHexAddress(), vlhgcRegion.getHexAddress(), currentAllocationContextTarok.getHexAddress() + " (" + currentAllocationContextTarok._allocationContextType() + ")", currentTenant.getHexAddress() + " \"" + currentTenantID + "\"");
                            continue;
                        }
                        table.row(currentObject.getHexAddress() + " //" + objectClassString, currentTargetObject.getHexAddress(), vlhgcRegion.getHexAddress(), currentAllocationContextTarok.getHexAddress() + " (" + currentAllocationContextTarok._allocationContextType() + ")");
                    }
                }
            }
            table.render(out);
        }
    }

    private void dumpLiveReferences(J9JavaVMPointer vm, J9ObjectPointer targetObject, PrintStream out) throws CorruptDataException {
        MM_HeapRegionManagerPointer hrmPointer = MM_GCExtensionsPointer.cast(vm.gcExtensions()).heapRegionManager();
        GCHeapRegionManager heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(hrmPointer);
        Table table = new Table("All Live Objects That Refer To !j9object " + targetObject.getHexAddress());
        table.row("Object");
        LiveSetWalker.walkLiveSet(new LiveReferenceVisitor(heapRegionManager, targetObject, table));
        table.render(out);
    }

    class LiveReferenceVisitor
    implements LiveSetWalker.ObjectVisitor {
        GCHeapRegionManager heapRegionManager;
        J9ObjectPointer mainObject;
        Table table;

        public LiveReferenceVisitor(GCHeapRegionManager heapRegionManager, J9ObjectPointer object, Table table) {
            this.heapRegionManager = heapRegionManager;
            this.mainObject = object;
            this.table = table;
        }

        public boolean visit(J9ObjectPointer object, VoidPointer address) {
            try {
                GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(object, false);
                while (fieldIterator.hasNext()) {
                    J9ObjectPointer fieldObject = fieldIterator.next();
                    if (!this.mainObject.eq(fieldObject)) continue;
                    J9ClassPointer objectClass = J9ObjectHelper.clazz(object);
                    String objectClassString = J9ClassHelper.getJavaName(objectClass);
                    this.table.row("!j9object " + object.getHexAddress() + " //" + objectClassString);
                }
            }
            catch (CorruptDataException e) {
                return false;
            }
            return true;
        }

        public void finishVisit(J9ObjectPointer object, VoidPointer address) {
        }
    }
}

