/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ArrayClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.structureformat.extensions.J9ObjectStructureFormatter;
import com.ibm.j9ddr.vm27.types.U32;
import java.io.PrintStream;
import java.util.Iterator;

public class PackedDataCommand
extends Command {
    public PackedDataCommand() {
        this.addCommand("packeddata", "<class> <addr>", "Display the contents of a packed object");
        this.addCommand("packeddata", "<class> <addr> <start> <end>", "Display the contents of a packed array object");
    }

    private void printUsage(PrintStream out) {
        out.println("packeddata <class> <addr> - Display the contents of a packed object");
        out.println("packeddata <class> <addr> <start> <end> - Display the contents of a packed array");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        block10: {
            try {
                if (2 == args.length || 4 == args.length) {
                    long classAddr = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
                    long dataAddr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                    J9ClassPointer classPointer = J9ClassPointer.cast(classAddr);
                    if (!J9ClassHelper.hasValidEyeCatcher(classPointer)) {
                        throw new IllegalArgumentException(String.format("Invalid class 0x%x", classPointer.getAddress()));
                    }
                    if (!J9ClassHelper.isPacked(classPointer)) {
                        throw new IllegalArgumentException(String.format("Class 0x%x is not a packed class", classPointer.getAddress()));
                    }
                    boolean isPackedArray = J9ClassHelper.isPackedArrayClass(classPointer);
                    if (4 == args.length) {
                        if (!isPackedArray) {
                            throw new IllegalArgumentException(String.format("Class 0x%x is not a packed array class", classPointer.getAddress()));
                        }
                        int begin = Integer.parseInt(args[2]);
                        int end = Integer.parseInt(args[3]);
                        this.printPackedArrayObject(out, dataAddr, classPointer, begin, end);
                    } else if (isPackedArray) {
                        out.println(String.format("Class 0x%x is an array class, please specify a range", classPointer.getAddress()));
                        out.println(String.format("!packeddata 0x%x 0x%x 0 1", classPointer.getAddress(), dataAddr));
                    } else {
                        this.printPackedObject(out, dataAddr, classPointer);
                    }
                    break block10;
                }
                out.println("Invalid args. Usage: ");
                this.printUsage(out);
                return;
            }
            catch (Exception e) {
                throw new DDRInteractiveCommandException(e);
            }
        }
    }

    private void printPackedArrayObject(PrintStream out, long dataAddr, J9ClassPointer classPointer, int begin, int end) throws CorruptDataException {
        J9ObjectStructureFormatter formatter = new J9ObjectStructureFormatter();
        out.println("{");
        formatter.printPackedArray(out, 1, classPointer, U8Pointer.cast(dataAddr), classPointer, begin, end, end, 0L);
        out.println("} // " + J9ArrayClassHelper.getJavaName(classPointer));
    }

    private void printPackedObject(PrintStream out, long dataAddr, J9ClassPointer classPointer) throws CorruptDataException {
        J9ObjectStructureFormatter formatter = new J9ObjectStructureFormatter();
        out.println("{");
        U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
        Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(classPointer.romClass(), classPointer, J9ClassPointer.NULL, flags);
        while (iterator.hasNext()) {
            J9ObjectFieldOffset result = iterator.next();
            formatter.printObjectField(out, 1, classPointer, U8Pointer.cast(dataAddr), classPointer, result, 0L);
            out.println();
        }
        out.println("} // " + J9ArrayClassHelper.getJavaName(classPointer));
    }
}

