/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.ClassSummaryHelper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class RamClassSummaryCommand
extends Command {
    private long numberOfClasses;
    private final String[] preferredOrder = new String[]{"jitVTables", "ramHeader", "vTable", "Extended method block", "RAM methods", "Constant Pool", "Ram static", "Superclasses", "InstanceDescription", "iTable"};

    public RamClassSummaryCommand() {
        this.addCommand("ramclasssummary", "", "Display ram class summary");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSummaryHelper classSummaryHelper = new ClassSummaryHelper(this.preferredOrder);
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer classPointer = (J9ClassPointer)classSegmentIterator.next();
                ++this.numberOfClasses;
                RamClassWalker classWalker = new RamClassWalker(classPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode allRegionsNode = linearDumper.getAllRegions(classWalker);
                classSummaryHelper.addRegionsForClass(allRegionsNode);
            }
            classSummaryHelper.printStatistics(out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    public long getNumberOfClasses() {
        return this.numberOfClasses;
    }
}

