/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;

public class RomClassForNameCommand
extends Command {
    public RomClassForNameCommand() {
        this.addCommand("romclassforname", "<name>", "find all the romclasses corresponding to name (with wildcards)");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printUsage(out);
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ROMClassesIterator iterator = new ROMClassesIterator(out, vm.classMemorySegments());
            int hitCount = 0;
            String searchClassName = args[0];
            PatternString pattern = new PatternString(searchClassName);
            out.println(String.format("Searching for ROMClasses named '%1$s' in VM=%2$s", searchClassName, Long.toHexString(vm.getAddress())));
            while (iterator.hasNext()) {
                J9ROMClassPointer romClassPointer = iterator.next();
                String javaName = J9UTF8Helper.stringValue(romClassPointer.className());
                if (!pattern.isMatch(javaName)) continue;
                ++hitCount;
                String hexString = romClassPointer.getHexAddress();
                out.println(String.format("!j9romclass %1$s named %2$s", hexString, javaName));
            }
            out.println(String.format("Found %1$d ROMClass(es) named %2$s", hitCount, searchClassName));
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printUsage(PrintStream out) {
        out.println("romclassforname <name> - find the class corresponding to name (with wildcards)");
    }
}

