/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.StringTable;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;

public class SearchStringTableCommand
extends Command {
    public SearchStringTableCommand() {
        this.addCommand("searchstringtable", "<address>", "Search for J9Object* in string table");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        block5: {
            try {
                if (1 == args.length) {
                    J9ObjectPointer objectPointer = J9ObjectPointer.cast(CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64));
                    J9ObjectPointer data = StringTable.from().search(objectPointer);
                    if (data.notNull()) {
                        String stringValue = J9ObjectHelper.stringValue(data);
                        String hexAddr = data.formatShortInteractive();
                        out.println(String.format("%s <%s>", hexAddr, stringValue));
                    } else {
                        out.println("Not found");
                    }
                    break block5;
                }
                throw new DDRInteractiveCommandException("This debug extension needs an address argument !searchstringtable <addr>");
            }
            catch (CorruptDataException e) {
                throw new DDRInteractiveCommandException(e);
            }
        }
    }
}

