/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm27.structure.J9MemorySegment;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentsUtil {
    private static final String nl = System.getProperty("line.separator");

    public static void dbgDumpSegmentList(PrintStream out, J9MemorySegmentListPointer segmentListPointer) throws CorruptDataException {
        String fmt = null;
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            out.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            fmt = " %016x %016x %016x %016x %08x %8x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator segmentIterator = new MemorySegmentIterator(segmentListPointer, -1, false);
        long totalMemory = 0L;
        long totalMemoryInUse = 0L;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            totalMemory += seg.size().longValue();
            totalMemoryInUse += seg.heapAlloc().sub(seg.heapBase()).longValue();
            String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), seg.heapAlloc().getAddress(), seg.heapTop().getAddress(), seg.type().longValue(), seg.size().longValue());
            out.append(msg);
            out.append(nl);
            seg = segmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(out, totalMemory, totalMemoryInUse);
        out.append(nl);
    }

    public static void dbgDumpJITCodeSegmentList(PrintStream out, J9MemorySegmentListPointer segmentListPointer) throws CorruptDataException {
        String fmt = null;
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            out.append("|    segment     |     start      |    warmAlloc   |    coldAlloc   |      end       |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            fmt = " %016x %016x %016x %016x %016x %8x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  |  warm  |  cold  |  end   |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator segmentIterator = new MemorySegmentIterator(segmentListPointer, -1, false);
        long totalMemory = 0L;
        long totalMemoryInUse = 0L;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            UDATA heapBase = UDATAPointer.cast(seg.heapBase()).at(0L);
            long warmAlloc = UDATAPointer.cast(heapBase).at(0L).longValue();
            long coldAlloc = UDATAPointer.cast(heapBase.add(UDATA.SIZEOF)).at(0L).longValue();
            totalMemory += seg.size().longValue();
            totalMemoryInUse += warmAlloc - seg.heapBase().longValue() + (seg.heapTop().longValue() - coldAlloc);
            String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), warmAlloc, coldAlloc, seg.heapTop().getAddress(), seg.size().longValue());
            out.append(msg);
            out.append(nl);
            seg = segmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(out, totalMemory, totalMemoryInUse);
        out.append(nl);
    }

    private static void printMemoryUsed(PrintStream out, long totalMemory, long totalMemoryInUse) {
        long totalMemoryFree = totalMemory - totalMemoryInUse;
        out.println(String.format("Total memory:           %016d (%016x)", totalMemory, totalMemory));
        out.println(String.format("Total memory in use:    %016d (%016x)", totalMemoryInUse, totalMemoryInUse));
        out.println(String.format("Total memory free:      %016d (%016x)", totalMemoryFree, totalMemoryFree));
    }

    private static void addSegmentsToArrayList(J9MemorySegmentListPointer segmentListPointer, ArrayList<J9MemorySegmentPointer> segmentArray, int segmentType) throws CorruptDataException {
        MemorySegmentIterator segmentIterator = new MemorySegmentIterator(segmentListPointer, segmentType, false);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            segmentArray.add(seg);
        }
    }

    private static J9MemorySegmentPointer[] getSortedSegments(J9JavaVMPointer vm, int segmentType) throws CorruptDataException {
        ArrayList<J9MemorySegmentPointer> segmentArray = new ArrayList<J9MemorySegmentPointer>();
        try {
            SegmentsUtil.addSegmentsToArrayList(vm.memorySegments(), segmentArray, segmentType);
            SegmentsUtil.addSegmentsToArrayList(vm.classMemorySegments(), segmentArray, segmentType);
            if (J9BuildFlags.interp_nativeSupport && !vm.jitConfig().isNull()) {
                SegmentsUtil.addSegmentsToArrayList(vm.jitConfig().codeCacheList(), segmentArray, segmentType);
                SegmentsUtil.addSegmentsToArrayList(vm.jitConfig().dataCacheList(), segmentArray, segmentType);
            }
        }
        catch (SegmentSortException e) {
            throw e.getCause();
        }
        J9MemorySegmentPointer[] sortedSegmentArray = segmentArray.toArray(new J9MemorySegmentPointer[segmentArray.size()]);
        Arrays.sort(sortedSegmentArray, new SegmentComparator());
        return sortedSegmentArray;
    }

    private static boolean findOverlappingSegments(J9MemorySegmentPointer[] sortedSegmentArray, boolean[] overlaps) throws CorruptDataException {
        if (sortedSegmentArray.length > 1) {
            boolean foundOverlaps = false;
            long heapTop = sortedSegmentArray[0].heapTop().getAddress();
            overlaps[0] = false;
            for (int i = 1; i < sortedSegmentArray.length; ++i) {
                if (sortedSegmentArray[i].heapBase().getAddress() >= heapTop) {
                    heapTop = sortedSegmentArray[i].heapTop().getAddress();
                    overlaps[i] = false;
                    continue;
                }
                foundOverlaps = true;
                overlaps[i - 1] = true;
                overlaps[i] = true;
                if (sortedSegmentArray[i].heapTop().getAddress() <= heapTop) continue;
                heapTop = sortedSegmentArray[i].heapTop().getAddress();
            }
            return foundOverlaps;
        }
        return false;
    }

    private static String fmtSegment(String fmt, J9MemorySegmentPointer seg) throws CorruptDataException {
        String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), seg.heapAlloc().getAddress(), seg.heapTop().getAddress(), seg.type().longValue(), seg.size().longValue());
        return msg;
    }

    private static void printOverlappingSegments(PrintStream out, J9MemorySegmentPointer[] sortedSegmentArray, boolean[] overlaps) throws CorruptDataException {
        String fmt;
        out.append("Overlapping segments:");
        out.append(nl);
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            out.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            fmt = " %016x %016x %016x %016x %08x %8x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        out.append(nl);
        for (int i = 0; i < overlaps.length; ++i) {
            if (!overlaps[i]) continue;
            out.append(SegmentsUtil.fmtSegment(fmt, sortedSegmentArray[i]));
            out.append(nl);
        }
    }

    public static void checkSegmentsForOverlap(PrintStream out, J9JavaVMPointer vm, int segmentType) throws CorruptDataException {
        boolean[] overlaps;
        boolean foundOverlaps = false;
        J9MemorySegmentPointer[] sortedSegmentArray = SegmentsUtil.getSortedSegments(vm, segmentType);
        if (sortedSegmentArray != null && sortedSegmentArray.length > 1 && SegmentsUtil.findOverlappingSegments(sortedSegmentArray, overlaps = new boolean[sortedSegmentArray.length])) {
            SegmentsUtil.printOverlappingSegments(out, sortedSegmentArray, overlaps);
            if (0L != ((long)segmentType & J9MemorySegment.MEMORY_TYPE_SHARED_META)) {
                out.append(nl);
                String msg = String.format("**NOTE** If -Xshareclasses is enabled, then the shared cache's metadata segment (type %08x)" + nl + "is expected to overlap with ROM class segments (type %08x) in the cache.", J9MemorySegment.MEMORY_TYPE_SHARED_META, J9MemorySegment.MEMORY_TYPE_ROM_CLASS);
                out.append(msg);
                out.append(nl);
            }
            foundOverlaps = true;
        }
        if (!foundOverlaps) {
            out.append("No overlaps found" + nl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SegmentComparator
    implements Comparator<J9MemorySegmentPointer> {
        private SegmentComparator() {
        }

        @Override
        public int compare(J9MemorySegmentPointer s1, J9MemorySegmentPointer s2) {
            try {
                if (s1.getAddress() == s2.getAddress()) {
                    return 0;
                }
                if (s1.heapBase().getAddress() < s2.heapBase().getAddress()) {
                    return -1;
                }
                if (s1.heapBase().getAddress() > s2.heapBase().getAddress()) {
                    return 1;
                }
                if (s1.heapTop().getAddress() < s2.heapTop().getAddress()) {
                    return -1;
                }
                if (s1.heapTop().getAddress() > s2.heapTop().getAddress()) {
                    return 1;
                }
                return 0;
            }
            catch (CorruptDataException e) {
                throw new SegmentSortException("Failed to sort memory segments", e);
            }
        }
    }

    private static class SegmentSortException
    extends RuntimeException {
        SegmentSortException(String msg, CorruptDataException cause) {
            super(msg, cause);
        }

        public CorruptDataException getCause() {
            return this.getCause();
        }
    }
}

