/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.J9JavaVM;
import java.io.PrintStream;

public class SetVMCommand
extends Command {
    public SetVMCommand() {
        this.addCommand("setvm", "<address>", "set the JavaVM address");
    }

    private void printHelp(PrintStream out) {
        out.append("Usage: \n");
        out.append("  !setvm <address>\n");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (1 != args.length) {
            this.printHelp(out);
            return;
        }
        long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        J9JavaVMPointer vmPtr = J9JavaVMPointer.cast(address);
        if (this.testJavaVMPtr(vmPtr)) {
            J9RASHelper.setCachedVM(vmPtr);
            out.println("VM set to " + vmPtr.getHexAddress());
            return;
        }
        J9VMThreadPointer threadPtr = J9VMThreadPointer.cast(address);
        try {
            vmPtr = threadPtr.javaVM();
            if (this.testJavaVMPtr(vmPtr)) {
                J9RASHelper.setCachedVM(vmPtr);
                out.println("VM set to " + vmPtr.getHexAddress());
                return;
            }
        }
        catch (CorruptDataException e) {
            // empty catch block
        }
        out.println("Error: Specified value (=" + address + ") is not a javaVM or vmThread pointer, VM not set");
    }

    private boolean testJavaVMPtr(J9JavaVMPointer vmPtr) {
        try {
            if (vmPtr.reserved1().longValue() == J9JavaVM.J9VM_IDENTIFIER) {
                return true;
            }
        }
        catch (CorruptDataException e) {
            return false;
        }
        return false;
    }
}

