/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.gc.GCFinalizableObjectIterator;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckFinalizableList
extends Check {
    CheckFinalizableList() {
    }

    public void check() {
        try {
            GCFinalizableObjectIterator finalizableObjectIterator = GCFinalizableObjectIterator.from();
            while (finalizableObjectIterator.hasNext()) {
                if (this._engine.checkSlotFinalizableList(finalizableObjectIterator.next()) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "FINALIZABLE";
    }

    public void print() {
        try {
            ScanFormatter formatter = new ScanFormatter(this, "finalizableList");
            GCFinalizableObjectIterator finalizableObjectIterator = GCFinalizableObjectIterator.from();
            int state = finalizableObjectIterator.getState();
            while (finalizableObjectIterator.hasNext()) {
                if (finalizableObjectIterator.getState() != state) {
                    formatter.endSection();
                    state = finalizableObjectIterator.getState();
                    switch (state) {
                        case 1: {
                            formatter.section("finalizable objects created by the system classloader");
                            break;
                        }
                        case 2: {
                            formatter.section("finalizable objects created by application class loaders");
                            break;
                        }
                        case 3: {
                            formatter.section("reference objects");
                        }
                    }
                }
                formatter.entry(finalizableObjectIterator.next());
            }
            formatter.end("finalizableList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

